/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.writer;

import com.aliyun.dataworks.common.spec.annotation.SpecWriter;
import com.aliyun.dataworks.common.spec.utils.ReflectUtils;
import com.aliyun.dataworks.common.spec.writer.SpecWriterContext;
import com.aliyun.dataworks.common.spec.writer.Writer;
import com.aliyun.dataworks.common.spec.writer.impl.AbstractWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.collections4.SetUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterFactory {
    private static final Logger log = LoggerFactory.getLogger(WriterFactory.class);
    private static final Set<Class<? extends AbstractWriter>> writers = new CopyOnWriteArraySet<Class<? extends AbstractWriter>>();

    private static synchronized void scanWritersByClassLoader() {
        if (writers.isEmpty()) {
            Set<Class<?>> subTypeClasses = ReflectUtils.getSubTypeOf(Writer.class.getPackage().getName(), AbstractWriter.class);
            SetUtils.emptyIfNull(subTypeClasses).stream().filter(clz -> clz.isAnnotationPresent(SpecWriter.class)).forEach(clz -> writers.add((Class<? extends AbstractWriter>)clz));
        }
    }

    private static synchronized void scanWriterByReflections() {
        Reflections reflections = new Reflections(Writer.class.getPackage().getName(), new Scanner[0]);
        Set clzSet = reflections.getSubTypesOf(AbstractWriter.class);
        SetUtils.emptyIfNull((Set)clzSet).stream().filter(AbstractWriter.class::isAssignableFrom).filter(clz -> clz.getAnnotation(SpecWriter.class) != null).forEach(writers::add);
    }

    public static Writer getWriter(Class from, SpecWriterContext context) {
        if (writers.isEmpty()) {
            WriterFactory.scanWriterByReflections();
        }
        return writers.stream().map(w -> {
            try {
                return (AbstractWriter)w.getConstructor(SpecWriterContext.class).newInstance(context);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }).filter(w -> w.matchType(from)).findFirst().orElse(null);
    }
}

