/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.utils;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.annotation.JSONField;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.interfaces.LabelEnum;
import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import com.aliyun.dataworks.common.spec.parser.Parser;
import com.aliyun.dataworks.common.spec.parser.SpecParserContext;
import com.aliyun.dataworks.common.spec.parser.SpecParserFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecDevUtil {
    private static final Logger log = LoggerFactory.getLogger(SpecDevUtil.class);

    public static void setSpecObject(Object ownerObject, String fieldName, Object value, SpecParserContext parserContext) {
        Field declaredField = SpecDevUtil.getField(ownerObject, fieldName);
        Class<?> fieldClz = SpecDevUtil.getFieldClz(declaredField);
        String clzName = fieldClz.getSimpleName();
        Object resEntity = null;
        if (value instanceof List && List.class.isAssignableFrom(declaredField.getType())) {
            resEntity = SpecDevUtil.getListObj(clzName, (List)value, parserContext, declaredField);
        } else if (value instanceof Map && !List.class.isAssignableFrom(declaredField.getType())) {
            resEntity = SpecDevUtil.getSpecEntity(fieldClz, value, parserContext);
        } else if (value instanceof String) {
            SpecDevUtil.setRefEntity(ownerObject, clzName, value, parserContext, declaredField);
            return;
        }
        if (resEntity == null) {
            return;
        }
        SpecDevUtil.setValue(ownerObject, declaredField, resEntity);
    }

    public static void setSameKeyField(Map<String, Object> ctxMap, Object specObj, SpecParserContext parserContext) {
        SpecDevUtil.setSimpleField(ctxMap, specObj);
        SpecDevUtil.setEnumField(ctxMap, specObj);
        SpecDevUtil.setMapField(ctxMap, specObj);
        SpecDevUtil.setSimpleListField(ctxMap, specObj);
        SpecDevUtil.parserSpecFields(parserContext, ctxMap, specObj);
    }

    public static void setSimpleField(Map<String, Object> ctxMap, Object object) {
        List<Field> declaredFields = SpecDevUtil.getPropertyFields(object);
        SpecDevUtil.setSimpleField(ctxMap, object, declaredFields);
        if (object.getClass().getSuperclass() != null && object.getClass().getSuperclass() == SpecRefEntity.class) {
            Class<?> entityClass = object.getClass().getSuperclass();
            Field[] entityFields = entityClass.getDeclaredFields();
            SpecDevUtil.setSimpleField(ctxMap, object, Arrays.asList(entityFields));
        }
    }

    public static void setEnumField(Map<String, Object> ctxMap, Object object) {
        List<Field> declaredFields = SpecDevUtil.getPropertyFields(object);
        for (Field field : declaredFields) {
            String value;
            Class<?> type = field.getType();
            if (!type.isEnum() || !LabelEnum.class.isAssignableFrom(type) || (value = (String)ctxMap.get(field.getName())) == null) continue;
            LabelEnum label = (LabelEnum)LabelEnum.getByLabel(type, value);
            if (label != null) {
                SpecDevUtil.setValue(object, field, label);
                continue;
            }
            throw new SpecException(SpecErrorCode.ENUM_NOT_EXIST, "Enum not found.\nEnum: " + type.getSimpleName() + "\nValue:" + value);
        }
    }

    public static void setMapField(Map ctxMap, Object object) {
        List<Field> declaredFields = SpecDevUtil.getPropertyFields(object);
        for (Field field : declaredFields) {
            if (!Map.class.isAssignableFrom(field.getType())) continue;
            Object value = ctxMap.get(field.getName());
            SpecDevUtil.setValue(object, field, value);
        }
    }

    public static void setValue(Object ownerObject, Field clzField, Object targetObject) {
        try {
            clzField.setAccessible(true);
            clzField.set(ownerObject, targetObject);
            clzField.setAccessible(false);
        }
        catch (Exception e) {
            throw new SpecException(e, SpecErrorCode.FIELD_SET_FAIL, "Field set fail. Please check your spec content and field type.\nfield:" + clzField + "\nvalue:" + targetObject + "\nownerObject:" + ownerObject.getClass().getSimpleName());
        }
    }

    public static void setRefContext(Object ownerObject, Object value, SpecParserContext parserContext, Field clzField, String entityName) {
        SpecParserContext.SpecEntityContext specEntityContext = new SpecParserContext.SpecEntityContext();
        specEntityContext.setOwnerObject(ownerObject);
        specEntityContext.setEntityName(entityName);
        specEntityContext.setEntityField(clzField);
        specEntityContext.setEntityValue(value);
        parserContext.getRefEntityList().add(specEntityContext);
    }

    public static RefMsg parseRefId(String refId) {
        boolean validRef;
        RefMsg refMsg = new RefMsg();
        boolean bl = validRef = refId.startsWith("{{") && refId.endsWith("}}");
        if (!validRef) {
            refMsg.setId(refId);
            return refMsg;
        }
        String[] split = (refId = refId.substring(2, refId.length() - 2)).split("\\.");
        if (split.length == 2) {
            refMsg.setType(split[0]);
            refMsg.setId(split[1]);
        } else if (split.length == 1) {
            refMsg.setId(split[0]);
        } else {
            throw new SpecException(SpecErrorCode.REF_ID_PARSER_ERROR, "The reference id format is incorrect: " + refId);
        }
        return refMsg;
    }

    public static List<Field> getPropertyFields(Object obj) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (obj == null || ClassUtils.isPrimitiveOrWrapper(obj.getClass()) || obj instanceof String) {
            return fields;
        }
        SpecDevUtil.getPropertyFields(fields, obj.getClass());
        return fields;
    }

    private static void getPropertyFields(List<Field> fields, Class<?> clz) {
        if (clz.equals(Object.class) || ClassUtils.isPrimitiveOrWrapper(clz) || clz.equals(String.class)) {
            return;
        }
        ArrayList<Field> declared = new ArrayList<Field>(Arrays.asList(clz.getDeclaredFields()));
        fields.addAll(declared.stream().filter(field -> !field.getName().startsWith("this$")).filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList()));
        SpecDevUtil.getPropertyFields(fields, clz.getSuperclass());
    }

    public static void setEntityToCtx(Object object, SpecParserContext parserContext) {
        String id;
        if (!SpecRefEntity.class.isAssignableFrom(object.getClass())) {
            return;
        }
        Map<String, SpecRefEntity> entityMap = parserContext.getEntityMap();
        try {
            Field idField = SpecDevUtil.getPropertyFields(object).stream().filter(f -> StringUtils.equals((CharSequence)f.getName(), (CharSequence)"id")).findAny().orElseThrow(() -> new SpecException(SpecErrorCode.GET_ID_ERROR, "Failed to get id" + object.getClass().getSimpleName()));
            idField.setAccessible(true);
            id = (String)idField.get(object);
            idField.setAccessible(false);
        }
        catch (Exception e) {
            throw new SpecException(e, SpecErrorCode.GET_ID_ERROR, "Failed to get id" + object.getClass().getSimpleName());
        }
        if (id == null) {
            return;
        }
        String key = object.getClass().getSimpleName() + "#" + id;
        entityMap.put(key, (SpecRefEntity)object);
    }

    public static Object getObjectByParser(Class<?> clz, Object ctxObject, SpecParserContext parserContext) {
        return SpecParserFactory.getParser(clz.getSimpleName()).parse((Map)ctxObject, parserContext);
    }

    public static boolean isSimpleType(Class<?> fieldClz) {
        return fieldClz.isPrimitive() || fieldClz == Boolean.class || fieldClz == Byte.class || fieldClz == Short.class || fieldClz == Integer.class || fieldClz == Long.class || fieldClz == Float.class || fieldClz == Double.class || fieldClz == Character.class || fieldClz == String.class || fieldClz == Map.class || fieldClz.isEnum();
    }

    private static Field getField(Object holdObject, String fieldName) {
        Field declaredField;
        try {
            declaredField = holdObject.getClass().getDeclaredField(fieldName);
        }
        catch (Exception e) {
            SpecException ex = new SpecException(SpecErrorCode.FIELD_NOT_FOUND, "Cannot find field.\nClass:" + holdObject.getClass().getSimpleName() + " Object value:" + holdObject.getClass().getSimpleName());
            declaredField = Optional.ofNullable(holdObject.getClass().getSuperclass()).map(superClz -> {
                try {
                    return superClz.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return null;
                }
            }).orElseThrow(() -> ex);
        }
        return declaredField;
    }

    public static Class<?> getFieldClz(Field declaredField) {
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        Class clz = declaredField.getType();
        Type genericType = declaredField.getGenericType();
        Type elementType = null;
        if (genericType instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length > 0) {
            elementType = typeArguments[0];
        }
        if (elementType != null) {
            clz = (Class)elementType;
        }
        return clz;
    }

    public static void setSimpleListField(Map<String, Object> ctxMap, Object specObj) {
        Field[] declaredFields;
        for (Field field : declaredFields = specObj.getClass().getDeclaredFields()) {
            List listValue;
            Class<?> fieldClz;
            if (!List.class.isAssignableFrom(field.getType()) || !SpecDevUtil.isSimpleType(fieldClz = SpecDevUtil.getFieldClz(field)) || (listValue = (List)ctxMap.get(field.getName())) == null) continue;
            ArrayList result = new ArrayList(listValue.size());
            result.addAll(listValue);
            SpecDevUtil.setValue(specObj, field, result);
        }
    }

    private static void setRefEntity(Object holdObject, String simpleName, Object value, SpecParserContext contextMeta, Field declaredField) {
        value = SpecDevUtil.parseRefId((String)value).getId();
        SpecDevUtil.setRefContext(holdObject, SpecDevUtil.parseRefId((String)value).getId(), contextMeta, declaredField, simpleName);
    }

    private static Object getSpecEntity(Class clz, Object value, SpecParserContext parserContext) {
        Parser<?> parser = SpecParserFactory.getParser(clz.getSimpleName());
        if (parser == null) {
            try {
                return JSON.parseObject((String)JSON.toJSONString((Object)value), (Class)clz);
            }
            catch (Exception e) {
                log.warn("parse by json failed: {}, error: {}", (Object)clz, (Object)e.getMessage());
                return null;
            }
        }
        return parser.parse((Map)value, parserContext);
    }

    private static Object getListObj(String simpleName, List value, SpecParserContext parserContext, Field declaredField) {
        Class<?> fieldClz = SpecDevUtil.getFieldClz(declaredField);
        if (SpecDevUtil.isSimpleType(fieldClz)) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Parser<?> parser = SpecParserFactory.getParser(simpleName);
        for (Object elmCtx : value) {
            Object parse;
            if (elmCtx instanceof String) {
                elmCtx = SpecDevUtil.parseRefId((String)elmCtx).getId();
                SpecDevUtil.setRefContext(list, elmCtx, parserContext, declaredField, simpleName);
                continue;
            }
            if (parser == null) {
                parse = JSON.parseObject((String)JSON.toJSONString(elmCtx), fieldClz);
            } else {
                parse = parser.parse((Map)elmCtx, parserContext);
                SpecDevUtil.setEntityToCtx(parse, parserContext);
            }
            list.add(parse);
        }
        return list;
    }

    private static void setSimpleField(Map<String, Object> ctxMap, Object object, List<Field> entityFields) {
        for (Field field : entityFields) {
            Object value = ctxMap.get(field.getName());
            if (value == null) continue;
            Class<?> fieldType = field.getType();
            try {
                if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
                    SpecDevUtil.setValue(object, field, Integer.valueOf(value.toString()));
                    continue;
                }
                if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
                    SpecDevUtil.setValue(object, field, Long.valueOf(value.toString()));
                    continue;
                }
                if (fieldType.equals(Float.TYPE) || fieldType.equals(Float.class)) {
                    SpecDevUtil.setValue(object, field, Float.valueOf(value.toString()));
                    continue;
                }
                if (fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
                    SpecDevUtil.setValue(object, field, Double.valueOf(value.toString()));
                    continue;
                }
                if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                    SpecDevUtil.setValue(object, field, Boolean.valueOf(value.toString()));
                    continue;
                }
                if (fieldType.equals(Character.TYPE) || fieldType.equals(Character.class)) {
                    SpecDevUtil.setValue(object, field, Character.valueOf(value.toString().charAt(0)));
                    continue;
                }
                if (fieldType.equals(String.class)) {
                    SpecDevUtil.setValue(object, field, value.toString());
                    continue;
                }
                if (!fieldType.equals(BigDecimal.class)) continue;
                SpecDevUtil.setValue(object, field, value.toString());
            }
            catch (Exception e) {
                throw new SpecException(e, SpecErrorCode.FIELD_SET_FAIL, "Type conversion error.\nExpect type: " + fieldType.getSimpleName() + "\nActual value:" + value);
            }
        }
    }

    private static void parserSpecFields(SpecParserContext contextMeta, Map<String, Object> ctxMap, Object specObj) {
        for (Field field : specObj.getClass().getDeclaredFields()) {
            Class<?> fieldType = field.getType();
            if (SpecDevUtil.isSimpleType(fieldType) || !ctxMap.containsKey(field.getName())) continue;
            SpecDevUtil.setSpecObject(specObj, field.getName(), ctxMap.get(field.getName()), contextMeta);
        }
    }

    public static JSONObject writeJsonObject(Object specObj, boolean withoutCollectionFields) {
        if (specObj == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        List<Field> fields = SpecDevUtil.getPropertyFields(specObj);
        Optional.ofNullable(specObj.getClass().getSuperclass()).map(Class::getDeclaredFields).map(Arrays::asList).ifPresent(list -> fields.addAll(1, (Collection<Field>)list));
        fields.stream().filter(f -> !f.getName().contains("$") && !Modifier.isStatic(f.getModifiers())).filter(f -> Optional.ofNullable(f.getAnnotation(JSONField.class)).map(JSONField::serialize).orElse(true)).forEach(field -> {
            field.setAccessible(true);
            try {
                Object value = field.get(specObj);
                if (value == null) {
                    return;
                }
                if (LabelEnum.class.isAssignableFrom(value.getClass())) {
                    value = ((LabelEnum)value).getLabel();
                }
                if (withoutCollectionFields && (value instanceof Collection || value instanceof Map)) {
                    return;
                }
                json.put((Object)field.getName(), value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        return json;
    }

    public static class RefMsg {
        private String type;
        private String id;

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefMsg)) {
                return false;
            }
            RefMsg other = (RefMsg)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RefMsg;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String toString() {
            return "SpecDevUtil.RefMsg(type=" + this.getType() + ", id=" + this.getId() + ")";
        }
    }
}

