/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectUtils.class);

    public static List<Field> getPropertyFields(Object obj) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (obj == null || ClassUtils.isPrimitiveOrWrapper(obj.getClass()) || obj instanceof String) {
            return fields;
        }
        ReflectUtils.getPropertyFields(fields, obj.getClass());
        return fields;
    }

    private static List<String> getPossibleGetter(Field field) {
        ArrayList<CallSite> methods = new ArrayList<CallSite>();
        String fieldName = field.getName();
        String fieldNameWithoutIs = (fieldName = fieldName.replaceFirst("^" + fieldName.charAt(0), StringUtils.upperCase((String)String.valueOf(fieldName.charAt(0))))).startsWith("is") ? fieldName.replaceFirst("^is", "") : fieldName;
        fieldNameWithoutIs = fieldNameWithoutIs.replaceFirst("^" + fieldName.charAt(0), StringUtils.upperCase((String)String.valueOf(fieldName.charAt(0))));
        methods.add((CallSite)((Object)("get" + fieldName)));
        methods.add((CallSite)((Object)("is" + fieldName)));
        methods.add((CallSite)((Object)("is" + fieldNameWithoutIs)));
        methods.add((CallSite)((Object)("get" + fieldNameWithoutIs)));
        return methods.stream().distinct().collect(Collectors.toList());
    }

    private static List<String> getPossibleSetter(Field field) {
        ArrayList<CallSite> methods = new ArrayList<CallSite>();
        String fieldName = field.getName();
        String fieldNameWithoutIs = (fieldName = fieldName.replaceFirst("^" + fieldName.charAt(0), StringUtils.upperCase((String)String.valueOf(fieldName.charAt(0))))).startsWith("is") ? fieldName.replaceFirst("^is", "") : fieldName;
        fieldNameWithoutIs = fieldNameWithoutIs.replaceFirst("^" + fieldName.charAt(0), StringUtils.upperCase((String)String.valueOf(fieldName.charAt(0))));
        methods.add((CallSite)((Object)("set" + fieldName)));
        methods.add((CallSite)((Object)("set" + fieldNameWithoutIs)));
        return methods.stream().distinct().collect(Collectors.toList());
    }

    private static void getPropertyFields(List<Field> fields, Class<?> clz) {
        if (clz.equals(Object.class) || ClassUtils.isPrimitiveOrWrapper(clz) || clz.equals(String.class)) {
            return;
        }
        ArrayList<Field> declared = new ArrayList<Field>(Arrays.asList(clz.getDeclaredFields()));
        fields.addAll(declared.stream().filter(field -> !field.getName().startsWith("this$")).filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList()));
        ReflectUtils.getPropertyFields(fields, clz.getSuperclass());
    }

    public static <T> void setObjectFieldIfNotSetOrBlank(Object res, String fieldName, T value) {
        if (res == null) {
            return;
        }
        try {
            Field field = res.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object v = field.get(res);
            if (v == null || v instanceof String && StringUtils.isBlank((CharSequence)((String)v))) {
                field.set(res, value);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.warn("set field {} failed for object type: {}, exception: {}", new Object[]{fieldName, res.getClass(), e.getMessage()});
        }
    }

    public static <T> T getObjectField(Object res, String fieldName) {
        if (res == null) {
            return null;
        }
        try {
            Field field = res.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(res);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return null;
        }
    }

    public static Field getField(Object dto, String name) {
        Field field;
        block3: {
            field = null;
            try {
                field = dto.getClass().getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                List<Field> fields = ReflectUtils.getPropertyFields(dto);
                if (!CollectionUtils.isNotEmpty(fields)) break block3;
                field = fields.stream().filter(f -> f.getName().equalsIgnoreCase(name)).findAny().orElse(null);
            }
        }
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        return field;
    }

    public static <T> T getFieldValue(Object dto, String name) {
        Field field;
        block5: {
            field = null;
            try {
                field = dto.getClass().getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                List<Field> fields = ReflectUtils.getPropertyFields(dto);
                if (!CollectionUtils.isNotEmpty(fields)) break block5;
                field = fields.stream().filter(f -> f.getName().equalsIgnoreCase(name)).findAny().orElse(null);
            }
        }
        if (field == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            return (T)field.get(dto);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public static <T> void setFieldValue(Object dto, String name, T value) {
        Field field;
        block5: {
            field = null;
            try {
                field = dto.getClass().getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                List<Field> fields = ReflectUtils.getPropertyFields(dto);
                if (!CollectionUtils.isNotEmpty(fields)) break block5;
                field = fields.stream().filter(f -> f.getName().equalsIgnoreCase(name)).findAny().orElse(null);
            }
        }
        if (field == null) {
            return;
        }
        try {
            field.setAccessible(true);
            field.set(dto, value);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static Method getUniqueMethod(Class clazz, String methodName) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!StringUtils.equals((CharSequence)methodName, (CharSequence)method.getName())) continue;
            return method;
        }
        return null;
    }

    public static Set<Class<?>> getSubTypeOf(String packageName, Class<?> supperClass) {
        HashSet classes = new HashSet();
        ReflectUtils.scanPackage(packageName, supperClass::isAssignableFrom, classes);
        return SetUtils.unmodifiableSet(classes);
    }

    public static void scanPackage(String packageName, Predicate<Class<?>> predicate, Set<Class<?>> resultSet) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Optional.ofNullable(classLoader.getResource(packageName.replaceAll("[.]", "/"))).ifPresent(url -> {
            File file = new File(url.getFile());
            if (StringUtils.equalsIgnoreCase((CharSequence)"jar", (CharSequence)url.getProtocol())) {
                try {
                    List<JarEntry> entities = ReflectUtils.openJarUrl(url);
                    SetUtils.emptyIfNull(ReflectUtils.listSubdirectories(entities, url.getPath())).forEach(dir -> ReflectUtils.scanPackage(packageName + "." + dir, predicate, resultSet));
                    entities.forEach(jarEntry -> {
                        String className = jarEntry.getName().replaceAll("/", ".");
                        if (!jarEntry.isDirectory() && jarEntry.getName().endsWith(".class") && className.startsWith(packageName)) {
                            String classFileName = className.substring(StringUtils.length((CharSequence)packageName) + 1);
                            resultSet.add(ReflectUtils.getClass(classFileName, packageName));
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                Optional.ofNullable(file.listFiles(File::isDirectory)).map(Stream::of).ifPresent(s -> s.forEach(dir -> ReflectUtils.scanPackage(packageName + "." + dir.getName(), predicate, resultSet)));
                ReflectUtils.readClassesByStream(packageName, predicate, resultSet, url);
            }
        });
    }

    private static List<JarEntry> openJarUrl(URL url) throws IOException {
        try {
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            JarFile jarFile = connection.getJarFile();
            return jarFile.stream().collect(Collectors.toList());
        }
        catch (IllegalStateException e) {
            log.warn("open jar failed: {}", (Object)e.getMessage());
            JarURLConnection connection = (JarURLConnection)url.openConnection();
            JarFile jarFile = connection.getJarFile();
            return jarFile.stream().collect(Collectors.toList());
        }
    }

    private static void readClassesByStream(String packageName, Predicate<Class<?>> predicate, Set<Class<?>> resultSet, URL url) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
            bufferedReader.lines().filter(line -> line.endsWith(".class")).peek(line -> log.debug("line: {}", line)).map(classFileName -> ReflectUtils.getClass(classFileName, packageName)).filter(predicate).forEach(resultSet::add);
        }
        catch (IOException e) {
            log.error("scan classes error: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Set<String> listSubdirectories(List<JarEntry> entities, String jarPath) {
        HashSet directories = new HashSet();
        String directoryPath = jarPath.contains("!") ? jarPath.split("!")[1] : "";
        String finalDirectoryPath = directoryPath = StringUtils.startsWith((CharSequence)directoryPath, (CharSequence)"/") ? directoryPath.substring(1) : directoryPath;
        ListUtils.emptyIfNull(entities).forEach(entry -> {
            if (entry.isDirectory() && entry.getName().startsWith(finalDirectoryPath)) {
                String name = entry.getName().substring(finalDirectoryPath.length());
                name = RegExUtils.replacePattern((String)name, (String)"^/", (String)"");
                if (StringUtils.isNotBlank((CharSequence)(name = RegExUtils.replacePattern((String)name, (String)"/$", (String)"")))) {
                    directories.add(name);
                }
            }
        });
        return SetUtils.unmodifiableSet(directories);
    }

    private static Class<?> getClass(String classFileName, String packageName) {
        try {
            return Class.forName(packageName + "." + classFileName.substring(0, classFileName.lastIndexOf(".")));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

