/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.utils;

import java.util.Arrays;
import java.util.Map;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.StringUtils;

public class MapKeyMatchUtils {
    public static String pluralizeWithS(String word) {
        if (word == null) {
            return null;
        }
        return word + "s";
    }

    public static String singularTrimS(String word) {
        if (word == null) {
            return null;
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)word, (CharSequence)"s")) {
            return word.substring(0, word.length() - 1);
        }
        return word;
    }

    public static boolean matchIgnoreSinglePluralForm(String key, String toMatch) {
        return key.equalsIgnoreCase(MapKeyMatchUtils.pluralizeWithS(toMatch)) || key.equalsIgnoreCase(MapKeyMatchUtils.singularTrimS(toMatch));
    }

    public static <V> boolean containsIgnoreCase(Map<String, V> map, String ... key) {
        if (map == null) {
            return false;
        }
        return map.keySet().stream().anyMatch(k -> Arrays.stream(key).anyMatch(k1 -> StringUtils.equalsIgnoreCase((CharSequence)k, (CharSequence)k1)));
    }

    public static <V> void removeIgnoreCaseSingleAndPluralForm(Map<String, V> map, String ... key) {
        if (map == null || key == null || key.length == 0) {
            return;
        }
        map.keySet().stream().filter(k -> Arrays.stream(key).anyMatch(k1 -> MapKeyMatchUtils.matchIgnoreSinglePluralForm(k, k1))).findAny().ifPresent(map::remove);
    }

    public static <V> V getIgnoreCaseSingleAndPluralForm(Map<String, V> map, String ... key) {
        if (map == null || key == null || key.length == 0) {
            return null;
        }
        return map.keySet().stream().filter(k -> Arrays.stream(key).anyMatch(k1 -> MapKeyMatchUtils.matchIgnoreSinglePluralForm(k, k1))).findAny().map(map::get).orElse(null);
    }

    public static <V> void setIgnoreCaseSingleAndPluralFormValue(Map<String, V> map, V value, String ... key) {
        if (map == null || key == null || key.length == 0) {
            return;
        }
        if (MapKeyMatchUtils.getIgnoreCaseSingleAndPluralForm(map, key) == null) {
            map.put(key[0], value);
        } else {
            map.entrySet().stream().filter(ent -> Arrays.stream(key).anyMatch(k1 -> MapKeyMatchUtils.matchIgnoreSinglePluralForm((String)ent.getKey(), k1))).forEach(ent -> map.put((String)ent.getKey(), value));
        }
    }

    public static <V> V getValue(Map<String, V> map, BiPredicate<String, String> keyMatcher, String ... key) {
        if (map == null || key == null || key.length == 0) {
            return null;
        }
        return map.keySet().stream().filter(k -> Arrays.stream(key).anyMatch(k1 -> keyMatcher.test((String)k, (String)k1))).findAny().map(map::get).orElse(null);
    }
}

