/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GsonUtils.class);
    public static String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static Gson gson;
    public static Gson gsonNoPrettyPrint;
    public static Gson defaultGson;
    public static Gson longDateJson;

    public static synchronized void initGson() {
        LOGGER.info("initialize GsonUtils ...");
        gson = new GsonBuilder().setDateFormat(DATE_FORMAT).disableHtmlEscaping().setPrettyPrinting().create();
        gsonNoPrettyPrint = new GsonBuilder().setDateFormat(DATE_FORMAT).create();
        defaultGson = new GsonBuilder().setDateFormat(DATE_FORMAT).disableHtmlEscaping().create();
        longDateJson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateLongAdapter()).create();
        LOGGER.info("initialize GsonUtils done.");
    }

    public static String toJsonString(Object object) {
        if (object != null) {
            return gson.toJson(object);
        }
        return null;
    }

    public static <T> T fromJsonString(String jsonString, Type type) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)gson.fromJson(jsonString, type);
        }
        catch (Throwable e) {
            LOGGER.error("parse json type: {}, string: {}, exception: ", new Object[]{type.getTypeName(), jsonString, e});
            throw e;
        }
    }

    public static String toEnumString(Enum enumObj) {
        if (enumObj != null) {
            return enumObj.name();
        }
        return null;
    }

    static {
        GsonUtils.initGson();
    }

    public static class DateLongAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json != null && json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
                return this.convertLongToDate(json.getAsLong());
            }
            return (Date)context.deserialize(json, typeOfT);
        }

        public Date convertLongToDate(long timestamp) {
            GregorianCalendar gc = (GregorianCalendar)GregorianCalendar.getInstance();
            gc.setTimeInMillis(timestamp);
            return gc.getTime();
        }

        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            if (src != null) {
                context.serialize((Object)src.getTime(), new TypeToken<Long>(){}.getType());
            }
            return context.serialize((Object)src, typeOfSrc);
        }
    }

    public static class EnumKeyMapDeserializerAdapter<E extends Enum<E>, V>
    implements JsonDeserializer<Map<E, V>>,
    JsonSerializer<Map<E, V>> {
        public Map<E, V> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                return (Map)context.deserialize(json, typeOfT);
            }
            Type[] argTypes = ((ParameterizedType)typeOfT).getActualTypeArguments();
            HashMap resultMap = new HashMap();
            ((JsonObject)json).entrySet().forEach(ent -> {
                Enum k = EnumUtils.getEnum((Class)((Class)argTypes[0]), (String)((String)ent.getKey()));
                if (k != null) {
                    resultMap.put(k, context.deserialize((JsonElement)ent.getValue(), argTypes[1]));
                } else {
                    LOGGER.warn("get unknown enum value by name: {}, value: {}", ent.getKey(), ent.getValue());
                }
            });
            return resultMap;
        }

        public JsonElement serialize(Map<E, V> src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(src, typeOfSrc);
        }
    }
}

