/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.parser.impl;

import com.aliyun.dataworks.common.spec.annotation.SpecParser;
import com.aliyun.dataworks.common.spec.domain.enums.SpecStorageType;
import com.aliyun.dataworks.common.spec.domain.interfaces.LabelEnum;
import com.aliyun.dataworks.common.spec.domain.ref.storage.SpecStorage;
import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import com.aliyun.dataworks.common.spec.parser.Parser;
import com.aliyun.dataworks.common.spec.parser.SpecParserContext;
import com.aliyun.dataworks.common.spec.utils.SpecDevUtil;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SpecParser
public class SpecStorageParser
implements Parser<SpecStorage> {
    private static final Logger log = LoggerFactory.getLogger(SpecStorageParser.class);

    @Override
    public SpecStorage parse(Map<String, Object> rawContext, SpecParserContext specParserContext) {
        String storageTypeStr = MapUtils.getString(rawContext, (Object)"type");
        SpecStorageType storageType = LabelEnum.getByLabel(SpecStorageType.class, storageTypeStr);
        if (storageType == null) {
            SpecException ex = new SpecException(SpecErrorCode.PARSE_ERROR, "storage type " + storageTypeStr + " is not supported");
            log.warn("ignore parse storage error: {}", (Object)ex.getMessage());
            return null;
        }
        SpecStorage storage = SpecStorage.of(storageType);
        SpecDevUtil.setSimpleField(rawContext, storage);
        SpecDevUtil.setEntityToCtx(storage, specParserContext);
        return storage;
    }
}

