/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.parser.impl;

import com.aliyun.dataworks.common.spec.annotation.SpecParser;
import com.aliyun.dataworks.common.spec.domain.ref.file.SpecObjectStorageFile;
import com.aliyun.dataworks.common.spec.domain.ref.storage.SpecStorage;
import com.aliyun.dataworks.common.spec.parser.Parser;
import com.aliyun.dataworks.common.spec.parser.SpecParserContext;
import com.aliyun.dataworks.common.spec.utils.SpecDevUtil;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SpecParser
public class SpecObjectStorageFileParser
implements Parser<SpecObjectStorageFile> {
    private static final Logger log = LoggerFactory.getLogger(SpecObjectStorageFileParser.class);

    @Override
    public SpecObjectStorageFile parse(Map<String, Object> rawContext, SpecParserContext specParserContext) {
        SpecObjectStorageFile file = new SpecObjectStorageFile();
        SpecDevUtil.setSimpleField(rawContext, file);
        Map storageTypeStr = MapUtils.getMap(rawContext, (Object)"storage");
        SpecStorage storage = (SpecStorage)SpecDevUtil.getObjectByParser(SpecStorage.class, storageTypeStr, specParserContext);
        return Optional.ofNullable(storage).map(st -> {
            SpecObjectStorageFile newFile = SpecObjectStorageFile.newInstanceOf(st.getType());
            newFile.setStorage((SpecStorage)st);
            SpecDevUtil.setSimpleField(rawContext, newFile);
            SpecDevUtil.setEntityToCtx(newFile, specParserContext);
            return newFile;
        }).orElse(file);
    }
}

