/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.parser.impl;

import com.aliyun.dataworks.common.spec.annotation.SpecParser;
import com.aliyun.dataworks.common.spec.domain.noref.SpecAssertIn;
import com.aliyun.dataworks.common.spec.domain.noref.SpecAssertion;
import com.aliyun.dataworks.common.spec.domain.noref.SpecJoin;
import com.aliyun.dataworks.common.spec.domain.noref.SpecJoinBranch;
import com.aliyun.dataworks.common.spec.domain.noref.SpecLogic;
import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import com.aliyun.dataworks.common.spec.parser.SpecParserContext;
import com.aliyun.dataworks.common.spec.parser.impl.DefaultSpecParser;
import com.aliyun.dataworks.common.spec.utils.SpecDevUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;

@SpecParser
public class SpecJoinParser
extends DefaultSpecParser<SpecJoin> {
    public static final String KEY_JOIN = "join";
    public static final String KEY_LOGIC = "logic";
    public static final String KEY_BRANCHES = "branches";
    public static final String KEY_BRANCH_NAME = "name";
    public static final String KEY_LOGIC_EXPRESSION = "expression";
    public static final String KEY_BRANCH_ASSERTION = "assertion";
    public static final String KEY_BRANCH_ASSERTION_IN = "in";

    @Override
    public SpecJoin parse(Map<String, Object> rawContext, SpecParserContext specParserContext) {
        SpecJoin specJoin = new SpecJoin();
        SpecLogic specLogic = new SpecLogic();
        specJoin.setLogic(specLogic);
        specLogic.setExpression(MapUtils.emptyIfNull((Map)((Map)rawContext.get(KEY_LOGIC))).getOrDefault(KEY_LOGIC_EXPRESSION, ""));
        List ctxMapBranches = Optional.ofNullable(rawContext.get(KEY_BRANCHES)).orElse(new ArrayList());
        ArrayList<SpecJoinBranch> specJoinBranches = new ArrayList<SpecJoinBranch>();
        for (Object o : ctxMapBranches) {
            Map ctxMapBranch = (Map)o;
            SpecJoinBranch specJoinBranch = new SpecJoinBranch();
            if (!ctxMapBranch.containsKey(KEY_BRANCH_NAME)) {
                throw new SpecException(SpecErrorCode.PARSE_ERROR, "'name' field of branch is required");
            }
            SpecDevUtil.setSimpleField(ctxMapBranch, specJoinBranch);
            SpecDevUtil.setSpecObject(specJoinBranch, "nodeId", ctxMapBranch.get("nodeId"), specParserContext);
            SpecDevUtil.setSpecObject(specJoinBranch, "output", ctxMapBranch.get("output"), specParserContext);
            SpecDevUtil.setSimpleListField(ctxMapBranch, specJoinBranch);
            if (!ctxMapBranch.containsKey(KEY_BRANCH_ASSERTION)) {
                throw new SpecException(SpecErrorCode.PARSE_ERROR, "'assertion' field of branch is required");
            }
            Map assertion = (Map)ctxMapBranch.get(KEY_BRANCH_ASSERTION);
            SpecAssertion specAssertion = new SpecAssertion();
            SpecDevUtil.setSimpleField(assertion, specAssertion);
            if (assertion.containsKey(KEY_BRANCH_ASSERTION_IN)) {
                SpecAssertIn in = new SpecAssertIn();
                in.setValue((List)assertion.get(KEY_BRANCH_ASSERTION_IN));
                specAssertion.setIn(in);
            }
            specJoinBranch.setAssertion(specAssertion);
            specJoinBranches.add(specJoinBranch);
        }
        specJoin.setBranches(specJoinBranches);
        return specJoin;
    }

    @Override
    public String getKeyType() {
        return KEY_JOIN;
    }
}

