/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.parser.impl;

import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import com.aliyun.dataworks.common.spec.parser.Parser;
import com.aliyun.dataworks.common.spec.parser.SpecParserContext;
import com.aliyun.dataworks.common.spec.parser.SpecParserFactory;
import com.aliyun.dataworks.common.spec.utils.GsonUtils;
import com.aliyun.dataworks.common.spec.utils.SpecDevUtil;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSpecParser<T>
implements Parser<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultSpecParser.class);
    private Class<?> type = null;

    public DefaultSpecParser() {
    }

    public DefaultSpecParser(Class<?> type) {
        this.type = type;
    }

    @Override
    public T parse(Map<String, Object> rawContext, SpecParserContext specParserContext) {
        T specObj = this.instantiateSpecObject();
        SpecDevUtil.setSameKeyField(rawContext, specObj, specParserContext);
        return specObj;
    }

    protected T instantiateSpecObject() {
        if (this.type == null) {
            this.type = this.getParameterizedObjectType(0);
        }
        if (this.type == null) {
            throw new SpecException(SpecErrorCode.PARSE_ERROR, "parser can not find type of " + this.getClass());
        }
        try {
            return (T)this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("instantiate spec object type: {} error: ", this.type, (Object)e);
            throw new SpecException(e, SpecErrorCode.PARSE_ERROR, "parser create spec object error. type: " + this.type.getName() + ", msg:" + e.getMessage() + ".");
        }
    }

    public Class<T> getParameterizedObjectType() {
        return this.getParameterizedObjectType(0);
    }

    protected Class<?> getParameterizedObjectType(int index) throws IndexOutOfBoundsException {
        Type genType = this.getClass().getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    private Object parseFieldObject(String jsonKey, Class<?> fieldType, Object fieldObject, Class<?> actualTypeArgument, SpecParserContext specParserContext) {
        Parser<?> parser = this.getCustomParser(jsonKey);
        if (parser == null && (parser = SpecParserFactory.getParser(actualTypeArgument.getSimpleName())) == null) {
            SpecException ex = new SpecException(SpecErrorCode.PARSER_NOT_FOUND, "cannot find parser for: " + jsonKey);
            log.warn("{}", (Object)ex.getMessage());
            if (fieldObject != null) {
                log.debug("try parse object: {} by json deserialization", fieldObject);
                if (this.isListField(fieldType, fieldObject)) {
                    TypeToken typeToken = TypeToken.getParameterized(List.class, (Type[])new Type[]{actualTypeArgument});
                    return GsonUtils.fromJsonString(GsonUtils.toJsonString(fieldObject), typeToken.getType());
                }
                return GsonUtils.fromJsonString(GsonUtils.toJsonString(fieldObject), actualTypeArgument);
            }
            return null;
        }
        if (this.isListField(fieldType, fieldObject)) {
            return this.getListObj(parser, (List)fieldObject, specParserContext);
        }
        Object entity = parser.parse((Map)fieldObject, specParserContext);
        SpecDevUtil.setEntityToCtx(entity, specParserContext);
        return entity;
    }

    protected void parseSpecObjectFields(T specObject, Map<String, Object> contextMap, SpecParserContext specParserContext) {
        List<Field> fields = SpecDevUtil.getPropertyFields(specObject);
        for (String jsonKey : contextMap.keySet()) {
            Field declaredField;
            try {
                declaredField = ListUtils.emptyIfNull(fields).stream().filter(fd -> fd.getName().equals(jsonKey)).findAny().orElseThrow(() -> new NoSuchFieldException(jsonKey));
            }
            catch (Exception e) {
                if (!BooleanUtils.isTrue((Boolean)specParserContext.getIgnoreMissingFields())) {
                    throw new SpecException(e, SpecErrorCode.FIELD_NOT_FOUND, "Cannot find field in Specification. JSON key:" + jsonKey);
                }
                log.info("ignore missing field: {} in spec object type: {}", (Object)jsonKey, (Object)specObject.getClass().getSimpleName());
                continue;
            }
            Class<?> fieldType = declaredField.getType();
            if (SpecDevUtil.isSimpleType(fieldType)) continue;
            Class<?> actualTypeArgument = SpecDevUtil.getFieldClz(declaredField);
            Object entity = this.parseFieldObject(jsonKey, fieldType, contextMap.get(jsonKey), actualTypeArgument, specParserContext);
            SpecDevUtil.setValue(specObject, declaredField, entity);
        }
    }

    protected Parser<?> getCustomParser(String jsonKey) {
        return null;
    }

    protected boolean isListField(Class<?> fieldType, Object fieldObject) {
        return fieldObject instanceof List && fieldType == List.class;
    }

    protected ArrayList<Object> getListObj(Parser<?> parser, List<?> fieldObject, SpecParserContext specParserContext) {
        ArrayList<Object> entityList = new ArrayList<Object>();
        for (Object obj : fieldObject) {
            Object parsed = parser.parse((Map)obj, specParserContext);
            SpecDevUtil.setEntityToCtx(parsed, specParserContext);
            entityList.add(parsed);
        }
        return entityList;
    }
}

