/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.parser;

import com.aliyun.dataworks.common.spec.domain.Spec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.enums.ArtifactType;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import com.aliyun.dataworks.common.spec.parser.SpecParserContext;
import com.aliyun.dataworks.common.spec.parser.impl.DataWorksWorkflowSpecParser;
import com.aliyun.dataworks.common.spec.parser.impl.SpecParser;
import com.aliyun.dataworks.common.spec.utils.MapKeyMatchUtils;
import com.aliyun.dataworks.common.spec.utils.SpecDevUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToDomainRootParser {
    private static final Logger log = LoggerFactory.getLogger(ToDomainRootParser.class);
    Specification<Spec> specification;
    SpecParser<?> specParser;
    SpecParserContext specParserContext;
    Set<Class<? extends SpecRefEntity>> specRefEntityClasses;

    public Specification<?> parseToDomain(String spec) {
        if (spec == null) {
            return null;
        }
        this.specParserContext = new SpecParserContext();
        this.specParserContext.specInit(spec);
        this.initialize();
        this.preParser();
        this.refParser();
        return this.specification;
    }

    private void initialize() {
        String kind = (String)MapKeyMatchUtils.getIgnoreCaseSingleAndPluralForm(this.specParserContext.getContextMap(), "kind");
        String version = (String)MapKeyMatchUtils.getIgnoreCaseSingleAndPluralForm(this.specParserContext.getContextMap(), "version");
        log.info("spec kind: {}, version: {}", (Object)kind, (Object)version);
        this.specParserContext.setVersion(version);
        this.specification = new Specification();
        this.specification.setContext(this.specParserContext);
        this.specParser = this.getSpecParser(kind);
        Reflections reflections = new Reflections(SpecRefEntity.class.getPackage().getName(), new Scanner[0]);
        this.specRefEntityClasses = reflections.getSubTypesOf(SpecRefEntity.class);
    }

    private SpecParser<?> getSpecParser(String kind) {
        Reflections reflections = new Reflections(SpecParser.class.getPackage().getName(), new Scanner[0]);
        DataWorksWorkflowSpecParser defaultSpecParser = new DataWorksWorkflowSpecParser();
        SpecParser specialParser = reflections.getSubTypesOf(SpecParser.class).stream().filter(parserClz -> !parserClz.equals(defaultSpecParser.getClass())).map(parser -> {
            try {
                return (SpecParser)parser.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }).filter(parser -> parser.support(kind)).findAny().orElse(null);
        if (specialParser != null) {
            return specialParser;
        }
        if (defaultSpecParser.support(kind)) {
            return defaultSpecParser;
        }
        throw new SpecException(SpecErrorCode.PARSE_ERROR, "Not support spec kind: " + kind);
    }

    private void preParser() {
        Map<String, Object> contextMap = this.specParserContext.getContextMap();
        if (contextMap == null) {
            return;
        }
        SpecDevUtil.setSimpleField(contextMap, this.specification);
        SpecDevUtil.setEnumField(contextMap, this.specification);
        SpecDevUtil.setMapField(contextMap, this.specification);
        this.parserSpecFields(contextMap, this.specParserContext);
    }

    private void refParser() {
        List<SpecParserContext.SpecEntityContext> refEntityList = this.specParserContext.getRefEntityList();
        Map<String, SpecRefEntity> entityMap = this.specParserContext.getEntityMap();
        for (SpecParserContext.SpecEntityContext refElm : refEntityList) {
            this.replaceObj(refElm, this.findTargetElm(refElm, entityMap), refElm.getOwnerObject());
        }
    }

    private SpecRefEntity findTargetElm(SpecParserContext.SpecEntityContext refElm, Map<String, SpecRefEntity> entityMap) {
        if (refElm == null) {
            return null;
        }
        if (!MapUtils.emptyIfNull(entityMap).containsKey(refElm.getEntityKey())) {
            log.debug("find target children entity of: {}", (Object)refElm.getEntityName());
            Object id = refElm.getEntityValue();
            return this.specRefEntityClasses.stream().peek(clz -> log.debug("clz: {}", clz)).filter(clz -> clz.getSimpleName().equalsIgnoreCase(refElm.getEntityName())).findFirst().flatMap(clz -> this.specRefEntityClasses.stream().filter(clz::isAssignableFrom).filter(subClz -> !clz.equals(subClz)).peek(subClz -> log.debug("subClz: {}", subClz)).filter(subClz -> MapUtils.emptyIfNull((Map)entityMap).containsKey(subClz.getSimpleName() + "#" + id)).findAny().map(subClz -> (SpecRefEntity)entityMap.get(subClz.getSimpleName() + "#" + id))).orElse(null);
        }
        return entityMap.get(refElm.getEntityKey());
    }

    private void parserSpecFields(Map<String, Object> contextMap, SpecParserContext specParserContext) {
        Object spec = MapKeyMatchUtils.containsIgnoreCase(contextMap, "spec") ? this.specParser.parse((Map)contextMap.get("spec"), specParserContext) : this.specParser.parse((Map)contextMap, specParserContext);
        this.specification.setSpec((Spec)spec);
    }

    private void replaceObj(SpecParserContext.SpecEntityContext refElm, SpecRefEntity targetElm, Object ownerObject) {
        if (targetElm == null) {
            if (refElm.getEntityField() != null && "output".equalsIgnoreCase(refElm.getEntityField().getName())) {
                SpecNodeOutput ar = new SpecNodeOutput();
                ar.setData((String)refElm.getEntityValue());
                ar.setArtifactType(ArtifactType.NODE_OUTPUT);
                Optional.ofNullable(refElm.getOwnerObject()).filter(oo -> oo instanceof SpecDepend).map(oo -> ((SpecDepend)oo).getOutput()).map(SpecNodeOutput::getRefTableName).ifPresent(ar::setRefTableName);
                SpecDevUtil.setValue(ownerObject, refElm.getEntityField(), ar);
                return;
            }
            if (refElm.getEntityField() != null && "nodeId".equalsIgnoreCase(refElm.getEntityField().getName())) {
                SpecNode nodeId = new SpecNode();
                nodeId.setId((String)refElm.getEntityValue());
                SpecDevUtil.setValue(ownerObject, refElm.getEntityField(), nodeId);
                return;
            }
            throw new SpecException(SpecErrorCode.TARGET_ENTITY_NOT_FOUND, "Cannot find target entity.\nspec type:" + refElm.getEntityKey().replaceAll("#", " id:"));
        }
        if (ownerObject instanceof List) {
            List ownerList = (List)ownerObject;
            ownerList.add(targetElm);
        } else {
            Field field = refElm.getEntityField();
            SpecDevUtil.setValue(ownerObject, field, targetElm);
        }
        targetElm.setIsRef(true);
    }
}

