/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.parser;

import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import com.aliyun.dataworks.common.spec.parser.DefaultParserEnum;
import com.aliyun.dataworks.common.spec.parser.Parser;
import com.aliyun.dataworks.common.spec.parser.impl.DefaultSpecParser;
import com.aliyun.dataworks.common.spec.parser.impl.SpecParser;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class SpecParserFactory {
    private static final HashMap<String, Parser<?>> parserMap = new HashMap();

    private static void loadDefaultParser() {
        DefaultParserEnum[] values = DefaultParserEnum.values();
        Arrays.stream(values).forEach(v -> parserMap.put(v.getSpecClz().getSimpleName(), new DefaultSpecParser(v.getSpecClz())));
    }

    public static Parser<?> getParser(String parserName) {
        return parserMap.get(parserName);
    }

    static {
        SpecParserFactory.loadDefaultParser();
        Set parsers = new Reflections(SpecParser.class.getPackage().getName(), new Scanner[0]).getSubTypesOf(Parser.class);
        for (Class clazz : parsers) {
            try {
                Parser parser = (Parser)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (parser.getClass().getSuperclass() == DefaultSpecParser.class) {
                    parserMap.put(((DefaultSpecParser)parser).getParameterizedObjectType().getSimpleName(), parser);
                    continue;
                }
                CollectionUtils.emptyIfNull(parser.getKeyTypes()).forEach(key -> parserMap.put((String)key, parser));
                Arrays.stream(parser.getClass().getGenericInterfaces()).filter(type -> type instanceof ParameterizedType).map(type -> (ParameterizedType)type).findFirst().flatMap(specType -> Arrays.stream(specType.getActualTypeArguments()).filter(Objects::nonNull).findFirst().filter(type -> type instanceof Class).map(type -> (Class)type)).ifPresent(clz -> parserMap.put(clz.getSimpleName(), parser));
            }
            catch (Exception e) {
                throw new SpecException(e, SpecErrorCode.PARSER_LOAD_ERROR, "load parser error: " + e.getMessage());
            }
        }
    }
}

