/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.parser;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.SpecContext;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import com.aliyun.dataworks.common.spec.utils.ParserUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpecParserContext
extends SpecContext {
    private final HashMap<String, SpecRefEntity> entityMap = new HashMap();
    private final List<SpecEntityContext> refEntityList = new ArrayList<SpecEntityContext>();
    private Map<String, Object> contextMap;
    private Boolean ignoreMissingFields;

    public void specInit(String spec) {
        try {
            this.contextMap = ParserUtil.jsonToMap(JSONObject.parseObject((String)spec));
        }
        catch (Exception e) {
            throw new SpecException(e, SpecErrorCode.PARSE_ERROR, "Spec JSON parse failed.Please check the JSON format.");
        }
    }

    public Map<String, SpecRefEntity> getEntityMap() {
        return this.entityMap;
    }

    public List<SpecEntityContext> getRefEntityList() {
        return this.refEntityList;
    }

    public Map<String, Object> getContextMap() {
        return this.contextMap;
    }

    public Boolean getIgnoreMissingFields() {
        return this.ignoreMissingFields;
    }

    public void setIgnoreMissingFields(Boolean ignoreMissingFields) {
        this.ignoreMissingFields = ignoreMissingFields;
    }

    public static class SpecEntityContext {
        private static final String KEY_SEPARATOR = "#";
        private Object ownerObject;
        private String entityName;
        private Object entityValue;
        private Field entityField;

        public String getEntityKey() {
            return this.entityName + KEY_SEPARATOR + this.entityValue;
        }

        public Object getOwnerObject() {
            return this.ownerObject;
        }

        public void setOwnerObject(Object ownerObject) {
            this.ownerObject = ownerObject;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public void setEntityValue(Object entityValue) {
            this.entityValue = entityValue;
        }

        public void setEntityField(Field entityField) {
            this.entityField = entityField;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpecEntityContext)) {
                return false;
            }
            SpecEntityContext other = (SpecEntityContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$ownerObject = this.getOwnerObject();
            Object other$ownerObject = other.getOwnerObject();
            if (this$ownerObject == null ? other$ownerObject != null : !this$ownerObject.equals(other$ownerObject)) {
                return false;
            }
            String this$entityName = this.getEntityName();
            String other$entityName = other.getEntityName();
            if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
                return false;
            }
            Object this$entityValue = this.getEntityValue();
            Object other$entityValue = other.getEntityValue();
            if (this$entityValue == null ? other$entityValue != null : !this$entityValue.equals(other$entityValue)) {
                return false;
            }
            Field this$entityField = this.getEntityField();
            Field other$entityField = other.getEntityField();
            return !(this$entityField == null ? other$entityField != null : !((Object)this$entityField).equals(other$entityField));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpecEntityContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $ownerObject = this.getOwnerObject();
            result = result * 59 + ($ownerObject == null ? 43 : $ownerObject.hashCode());
            String $entityName = this.getEntityName();
            result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
            Object $entityValue = this.getEntityValue();
            result = result * 59 + ($entityValue == null ? 43 : $entityValue.hashCode());
            Field $entityField = this.getEntityField();
            result = result * 59 + ($entityField == null ? 43 : ((Object)$entityField).hashCode());
            return result;
        }

        public String toString() {
            return "SpecParserContext.SpecEntityContext(ownerObject=" + this.getOwnerObject() + ", entityName=" + this.getEntityName() + ", entityValue=" + this.getEntityValue() + ", entityField=" + this.getEntityField() + ")";
        }

        public String getEntityName() {
            return this.entityName;
        }

        public Object getEntityValue() {
            return this.entityValue;
        }

        public Field getEntityField() {
            return this.entityField;
        }
    }
}

