/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.ref.storage;

import com.aliyun.dataworks.common.spec.domain.SpecEntity;
import com.aliyun.dataworks.common.spec.domain.enums.SpecStorageType;
import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class SpecStorage
extends SpecEntity {
    private static final Set<Class<? extends SpecStorage>> subClz;
    private SpecStorageType type;

    public static SpecStorage of(SpecStorageType type) {
        if (type == null) {
            return null;
        }
        return SetUtils.emptyIfNull(subClz).stream().map(clz -> {
            try {
                return (SpecStorage)clz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }).filter(clz -> Objects.equals(type, clz.getType())).findFirst().orElseThrow(() -> new SpecException(SpecErrorCode.PARSE_ERROR, "storage type not supported: " + type));
    }

    public SpecStorageType getType() {
        return this.type;
    }

    public void setType(SpecStorageType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpecStorage)) {
            return false;
        }
        SpecStorage other = (SpecStorage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpecStorageType this$type = this.getType();
        SpecStorageType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpecStorage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SpecStorageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SpecStorage(super=" + super.toString() + ", type=" + this.getType() + ")";
    }

    static {
        Reflections reflections = new Reflections(SpecStorage.class.getPackage().getName(), new Scanner[0]);
        subClz = reflections.getSubTypesOf(SpecStorage.class);
    }
}

