/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.enums;

import com.aliyun.dataworks.common.spec.domain.interfaces.LabelEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SpecFileResourceType implements LabelEnum
{
    PYTHON("python"),
    JAR("jar"),
    ARCHIVE("archive"),
    FILE("file");

    private static final Logger log;
    private final String label;

    private SpecFileResourceType(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public SpecFileResourceType of(String label) {
        if (label == null) {
            log.error("label is null");
        }
        for (SpecFileResourceType type : SpecFileResourceType.values()) {
            if (!type.label.equalsIgnoreCase(label)) continue;
            return type;
        }
        log.error("SpecFileResourceType {} not found", (Object)label);
        return null;
    }

    static {
        log = LoggerFactory.getLogger(SpecFileResourceType.class);
    }
}

