/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.codemodel;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.AbstractBaseCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.ref.component.SpecComponent;
import com.aliyun.dataworks.common.spec.utils.GsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlComponentCode
extends AbstractBaseCode {
    private static final Logger log = LoggerFactory.getLogger(SqlComponentCode.class);
    private String code;
    @JsonAdapter(value=ComponentAdapter.class)
    private SpecComponent config;

    @Override
    public SqlComponentCode parse(String content) {
        SqlComponentCode sqlComponentCode;
        try {
            sqlComponentCode = Optional.ofNullable(GsonUtils.fromJsonString(content, SqlComponentCode.class)).map(c -> (SqlComponentCode)c).orElse(new SqlComponentCode());
        }
        catch (Exception e) {
            log.warn("parse sql component code error: {}, code: {}", (Object)e.getMessage(), (Object)content);
            sqlComponentCode = new SqlComponentCode();
        }
        this.code = sqlComponentCode.getCode();
        this.config = sqlComponentCode.getConfig();
        this.programType = sqlComponentCode.getProgramType();
        this.resourceReferences = sqlComponentCode.getResourceReferences();
        return sqlComponentCode;
    }

    @Override
    public List<String> getProgramTypes() {
        return Collections.singletonList(CodeProgramType.SQL_COMPONENT.name());
    }

    @Override
    public String getSourceCode() {
        return this.code;
    }

    @Override
    public void setSourceCode(String sourceCode) {
        this.code = sourceCode;
    }

    public String getCode() {
        return this.code;
    }

    public SpecComponent getConfig() {
        return this.config;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setConfig(SpecComponent config) {
        this.config = config;
    }

    @Override
    public String toString() {
        return "SqlComponentCode(code=" + this.getCode() + ", config=" + this.getConfig() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlComponentCode)) {
            return false;
        }
        SqlComponentCode other = (SqlComponentCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        SpecComponent this$config = this.getConfig();
        SpecComponent other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SqlComponentCode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        SpecComponent $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        return result;
    }

    protected static class ComponentAdapter
    implements JsonSerializer<SpecComponent> {
        protected ComponentAdapter() {
        }

        public JsonElement serialize(SpecComponent src, Type typeOfSrc, JsonSerializationContext context) {
            JsonElement ele = context.serialize((Object)src);
            if (ele != null && ele.isJsonObject()) {
                if (ele.getAsJsonObject().has("inputs")) {
                    ele.getAsJsonObject().add("input", ele.getAsJsonObject().get("inputs"));
                    ele.getAsJsonObject().remove("inputs");
                }
                if (ele.getAsJsonObject().has("outputs")) {
                    ele.getAsJsonObject().add("output", ele.getAsJsonObject().get("outputs"));
                    ele.getAsJsonObject().remove("outputs");
                }
            }
            return ele;
        }
    }
}

