/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.codemodel;

import com.alibaba.fastjson2.JSON;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.AbstractBaseCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.YamlFormCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.enums.SpecKind;
import com.aliyun.dataworks.common.spec.domain.enums.SpecVersion;
import com.aliyun.dataworks.common.spec.domain.enums.VariableScopeType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.interfaces.Input;
import com.aliyun.dataworks.common.spec.domain.interfaces.Output;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.paiflow.PaiflowArguments;
import com.aliyun.dataworks.common.spec.domain.paiflow.PaiflowArgumentsWrapper;
import com.aliyun.dataworks.common.spec.domain.paiflow.PaiflowArtifact;
import com.aliyun.dataworks.common.spec.domain.paiflow.PaiflowParameter;
import com.aliyun.dataworks.common.spec.domain.paiflow.PaiflowScriptContent;
import com.aliyun.dataworks.common.spec.domain.paiflow.PaiflowSpec;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.common.spec.parser.SpecParserContext;
import com.aliyun.dataworks.common.spec.utils.UuidUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class PaiflowYamlCode
extends AbstractBaseCode
implements YamlFormCode {
    private static final Logger log = LoggerFactory.getLogger(PaiflowYamlCode.class);
    public static final String PAIFLOW_CONF_KEY_ARGUMENT_PARAMETER = "parameters";
    private static final Pattern PAIFLOW_ARTIFACT_REGEX_PATTERN = Pattern.compile("\\{\\{pipelines\\.([^.]+)\\.outputs\\.artifacts\\.([^.]+)}}");
    private static final String METADATA_PAIFLOW_KEY = "paiflow";
    private PaiflowScriptContent paiflowScriptContent;

    public static Yaml getYaml() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Constructor constructor = new Constructor(new LoaderOptions());
        constructor.getPropertyUtils().setSkipMissingProperties(true);
        Representer representer = new Representer(options){

            protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
                return propertyValue == null ? null : super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
            }
        };
        return new Yaml((BaseConstructor)constructor, representer, options);
    }

    public Specification<DataWorksWorkflowSpec> getSpec(List<String> pipelineManifests) {
        Yaml yaml = PaiflowYamlCode.getYaml();
        List pipelinePaiflowSpecs = ListUtils.emptyIfNull(pipelineManifests).stream().map(x -> yaml.loadAs(x, PaiflowSpec.class)).map(x -> (PaiflowSpec)x).collect(Collectors.toList());
        Map<String, PaiflowParameter> parameterMap = Optional.ofNullable(this.paiflowScriptContent.getPaiflowArguments()).map(PaiflowArgumentsWrapper::getArguments).map(PaiflowArguments::getParameters).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(PaiflowParameter::getName, x -> x));
        Specification<DataWorksWorkflowSpec> specObj = new Specification<DataWorksWorkflowSpec>();
        DataWorksWorkflowSpec dwSpec = new DataWorksWorkflowSpec();
        specObj.setVersion(SpecVersion.V_1_1_0.getLabel());
        specObj.setKind(SpecKind.PAIFLOW.getLabel());
        specObj.setContext(new SpecParserContext());
        HashMap metadata = Maps.newHashMap();
        metadata.put(METADATA_PAIFLOW_KEY, this.paiflowScriptContent.getPaiflowPipeline().getMetadata());
        dwSpec.setMetadata(metadata);
        specObj.setSpec(dwSpec);
        ArrayList<SpecFlowDepend> flow = new ArrayList<SpecFlowDepend>();
        HashMap nodeMap = Maps.newHashMap();
        List<SpecNode> nodes = Optional.ofNullable(this.paiflowScriptContent.getPaiflowPipeline()).map(PaiflowSpec::getSpec).map(x -> {
            if (CollectionUtils.isEmpty(x.getPipelines())) {
                PaiflowSpec singlePipeline = new PaiflowSpec();
                singlePipeline.setApiVersion(this.paiflowScriptContent.getPaiflowPipeline().getApiVersion());
                singlePipeline.setMetadata(this.paiflowScriptContent.getPaiflowPipeline().getMetadata());
                singlePipeline.setSpec((PaiflowSpec)x);
                return Collections.singletonList(singlePipeline);
            }
            return x.getPipelines();
        }).orElse(Collections.emptyList()).stream().map(node -> this.buildSpecNodeByPaiflowSpec((PaiflowSpec)node, parameterMap, nodeMap, (List<SpecFlowDepend>)flow, pipelinePaiflowSpecs)).filter(Objects::nonNull).collect(Collectors.toList());
        flow.forEach(x -> x.getDepends().stream().filter(depend -> Objects.nonNull(depend.getNodeId())).filter(depend -> Objects.nonNull(nodeMap.get(depend.getNodeId().getName()))).forEach(depend -> depend.getNodeId().setId(((SpecNode)nodeMap.get(depend.getNodeId().getName())).getId())));
        dwSpec.setNodes(nodes);
        dwSpec.setFlow(flow);
        return specObj;
    }

    public PaiflowArguments buildPaiflowArguments(SpecScript script) {
        PaiflowArguments paiflowArguments = new PaiflowArguments();
        PaiflowArguments paiflowInputs = Optional.ofNullable(this.getPaiflowScriptContent()).map(PaiflowScriptContent::getPaiflowPipeline).map(PaiflowSpec::getSpec).map(PaiflowSpec::getInputs).orElse(null);
        if (null == paiflowInputs) {
            return paiflowArguments;
        }
        List<PaiflowArtifact> artifacts = Optional.ofNullable(paiflowInputs.getArtifacts()).orElse(Collections.emptyList()).stream().map(x -> {
            PaiflowArtifact paiflowArtifact = new PaiflowArtifact();
            paiflowArtifact.setName(x.getName());
            paiflowArtifact.setMetadata((Map<String, Object>)JSON.parseObject((String)JSON.toJSONString(x.getMetadata())));
            paiflowArtifact.setValue(String.format("${%s}", paiflowArtifact.getName()));
            return paiflowArtifact;
        }).collect(Collectors.toList());
        paiflowArguments.setParameters(Optional.ofNullable(script.getRuntime()).map(SpecScriptRuntime::getPaiflowConf).map(x -> x.get(PAIFLOW_CONF_KEY_ARGUMENT_PARAMETER)).map(x -> JSON.parseArray((String)JSON.toJSONString((Object)x), PaiflowParameter.class)).orElse(null));
        paiflowArguments.setArtifacts(artifacts);
        return paiflowArguments;
    }

    @Override
    public String getContent() {
        if (null == this.getPaiflowScriptContent()) {
            return "";
        }
        return PaiflowYamlCode.getYaml().dumpAsMap((Object)this.getPaiflowScriptContent());
    }

    public String getSchedulerContent() {
        if (null == this.getPaiflowScriptContent()) {
            return "";
        }
        return JSON.toJSONString((Object)this.getPaiflowScriptContent());
    }

    @Override
    public PaiflowYamlCode parse(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return new PaiflowYamlCode();
        }
        Object yamlObj = PaiflowYamlCode.getYaml().load(code);
        this.setPaiflowScriptContent((PaiflowScriptContent)JSON.parseObject((String)JSON.toJSONString((Object)yamlObj), PaiflowScriptContent.class));
        return this;
    }

    @Override
    public List<String> getProgramTypes() {
        return Collections.singletonList(CodeProgramType.PAI_FLOW.getName());
    }

    @Override
    public boolean support(String programType) {
        return programType.startsWith(CodeProgramType.PAI_FLOW.getName());
    }

    private SpecNode buildSpecNodeByPaiflowSpec(PaiflowSpec node, Map<String, PaiflowParameter> parameterMap, Map<String, SpecNode> nodeMap, List<SpecFlowDepend> flow, List<PaiflowSpec> pipelinePaiflowSpecs) {
        PaiflowSpec nodeSpec = node.getSpec();
        if (null == nodeSpec) {
            log.error("invalid node spec, without spec:{}", (Object)node);
            return null;
        }
        Map<String, Object> nodeMetadata = node.getMetadata();
        SpecNode nodeObj = new SpecNode();
        SpecScript script = new SpecScript();
        PaiflowArguments arguments = nodeSpec.getArguments();
        SpecScriptRuntime specScriptRuntime = new SpecScriptRuntime();
        HashMap metadata = Maps.newHashMap();
        metadata.put(METADATA_PAIFLOW_KEY, nodeMetadata);
        nodeObj.setMetadata(metadata);
        nodeObj.setScript(script);
        nodeObj.setName(this.getNodeName(String.valueOf(nodeMetadata.get("name"))));
        nodeObj.setId(UuidUtils.genUuidWithoutHorizontalLine());
        nodeMap.put(nodeObj.getName(), nodeObj);
        HashMap paiflowConf = Maps.newHashMap();
        specScriptRuntime.setPaiflowConf(paiflowConf);
        script.setRuntime(specScriptRuntime);
        SpecFlowDepend specFlowDepend = new SpecFlowDepend();
        specFlowDepend.setNodeId(nodeObj);
        Optional<PaiflowSpec> paiflowManifestSpec = ListUtils.emptyIfNull(pipelinePaiflowSpecs).stream().filter(x -> Objects.equals(x.getMetadata().get("identifier"), nodeMetadata.get("identifier")) && Objects.equals(x.getMetadata().get("provider"), nodeMetadata.get("provider")) && Objects.equals(x.getMetadata().get("version"), nodeMetadata.get("version"))).findFirst().map(PaiflowSpec::getSpec);
        List parametersWithValue = Optional.ofNullable(arguments).map(PaiflowArguments::getParameters).orElse(Collections.emptyList()).stream().map(x -> Optional.ofNullable((PaiflowParameter)parameterMap.get(x.getFromParameterName())).map(parameterWithValue -> {
            PaiflowParameter paiflowParameter = new PaiflowParameter();
            paiflowParameter.setName(x.getName());
            paiflowParameter.setValue(parameterWithValue.getValue());
            return paiflowParameter;
        }).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        List parametersWithDefaultValue = paiflowManifestSpec.map(PaiflowSpec::getInputs).map(PaiflowArguments::getParameters).orElse(Collections.emptyList()).stream().filter(x -> parametersWithValue.stream().noneMatch(y -> StringUtils.equals((CharSequence)x.getName(), (CharSequence)y.getName()))).map(x -> {
            PaiflowParameter paiflowParameter = new PaiflowParameter();
            paiflowParameter.setName(x.getName());
            paiflowParameter.setValue(x.getValue());
            if ("Map".equalsIgnoreCase(x.getType())) {
                paiflowParameter.setValue(Maps.newHashMap());
            }
            return paiflowParameter;
        }).collect(Collectors.toList());
        paiflowConf.put(PAIFLOW_CONF_KEY_ARGUMENT_PARAMETER, parametersWithValue.isEmpty() ? parametersWithDefaultValue : parametersWithValue);
        List<SpecVariable> variableParameters = paiflowManifestSpec.map(PaiflowSpec::getInputs).map(PaiflowArguments::getArtifacts).orElse(Collections.emptyList()).stream().map(x -> this.buildPaiOutputSpecVariable(x.getName(), null)).collect(Collectors.toList());
        Map<String, SpecVariable> variableParameterMap = variableParameters.stream().collect(Collectors.toMap(SpecVariable::getName, x -> x));
        LinkedHashMap nodeDepends = new LinkedHashMap();
        List inputVariableList = Optional.ofNullable(arguments).map(PaiflowArguments::getArtifacts).orElse(Collections.emptyList()).stream().filter(x -> variableParameterMap.containsKey(x.getName())).map(x -> this.buildSpecVariableByPaiflowArtifact((PaiflowArtifact)x, (SpecVariable)variableParameterMap.get(x.getName()), nodeDepends)).filter(Objects::nonNull).collect(Collectors.toList());
        nodeObj.setInputs(new ArrayList<Input>(inputVariableList));
        List outputContextList = paiflowManifestSpec.map(PaiflowSpec::getOutputs).map(PaiflowArguments::getArtifacts).orElse(Collections.emptyList()).stream().map(x -> this.buildPaiOutputSpecVariable(x.getName(), null)).collect(Collectors.toList());
        nodeObj.setOutputs(new ArrayList<Output>(outputContextList));
        script.setParameters(variableParameters);
        if (MapUtils.isNotEmpty(nodeDepends)) {
            specFlowDepend.setDepends(new ArrayList<SpecDepend>(nodeDepends.values()));
            flow.add(specFlowDepend);
        }
        return nodeObj;
    }

    private SpecVariable buildSpecVariableByPaiflowArtifact(PaiflowArtifact paiflowArtifact, SpecVariable parameterVariable, LinkedHashMap<String, SpecDepend> nodeDepends) {
        Matcher matcher = PAIFLOW_ARTIFACT_REGEX_PATTERN.matcher(paiflowArtifact.getFrom());
        if (!matcher.find()) {
            return null;
        }
        String fromNodeName = this.getNodeName(matcher.group(1));
        String fromArtifactName = matcher.group(2);
        SpecDepend specDepend = new SpecDepend();
        SpecNode dependNode = new SpecNode();
        dependNode.setName(fromNodeName);
        specDepend.setNodeId(dependNode);
        nodeDepends.putIfAbsent(fromNodeName, specDepend);
        parameterVariable.setReferenceVariable(this.buildPaiOutputSpecVariable(fromArtifactName, specDepend));
        return parameterVariable.getReferenceVariable();
    }

    private SpecVariable buildPaiOutputSpecVariable(String variableName, SpecDepend specDepend) {
        SpecVariable variable = new SpecVariable();
        variable.setName(variableName);
        variable.setType(VariableType.PAI_OUTPUT);
        variable.setScope(VariableScopeType.NODE_CONTEXT);
        variable.setNode(specDepend);
        return variable;
    }

    private String getNodeName(String paiflowNodeName) {
        return paiflowNodeName.replace("-", "_");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaiflowYamlCode)) {
            return false;
        }
        PaiflowYamlCode other = (PaiflowYamlCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PaiflowScriptContent this$paiflowScriptContent = this.getPaiflowScriptContent();
        PaiflowScriptContent other$paiflowScriptContent = other.getPaiflowScriptContent();
        return !(this$paiflowScriptContent == null ? other$paiflowScriptContent != null : !((Object)this$paiflowScriptContent).equals(other$paiflowScriptContent));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PaiflowYamlCode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PaiflowScriptContent $paiflowScriptContent = this.getPaiflowScriptContent();
        result = result * 59 + ($paiflowScriptContent == null ? 43 : ((Object)$paiflowScriptContent).hashCode());
        return result;
    }

    public PaiflowScriptContent getPaiflowScriptContent() {
        return this.paiflowScriptContent;
    }

    public PaiflowYamlCode setPaiflowScriptContent(PaiflowScriptContent paiflowScriptContent) {
        this.paiflowScriptContent = paiflowScriptContent;
        return this;
    }

    @Override
    public String toString() {
        return "PaiflowYamlCode(paiflowScriptContent=" + this.getPaiflowScriptContent() + ")";
    }
}

