/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.codemodel;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.AbstractBaseCode;
import com.aliyun.dataworks.common.spec.utils.GsonUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class JsonObjectCode
extends AbstractBaseCode {
    protected transient String rawContent;

    @Override
    public JsonObjectCode parse(String code) {
        this.rawContent = code;
        if (StringUtils.isBlank((CharSequence)code)) {
            return this;
        }
        JsonObjectCode joc = (JsonObjectCode)GsonUtils.fromJsonString(code, this.getClass());
        if (joc == null) {
            return this;
        }
        joc.setRawContent(code);
        return joc;
    }

    @Override
    public void setSourceCode(String sourceCode) {
        this.rawContent = sourceCode;
    }

    @Override
    public String getSourceCode() {
        return this.rawContent;
    }

    @Override
    public String getContent() {
        return super.getContent();
    }

    public JsonObjectCode setRawContent(String rawContent) {
        this.rawContent = rawContent;
        return this;
    }

    @Override
    public String getRawContent() {
        return this.rawContent;
    }

    @Override
    public String toString() {
        return "JsonObjectCode(rawContent=" + this.getRawContent() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonObjectCode)) {
            return false;
        }
        JsonObjectCode other = (JsonObjectCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JsonObjectCode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

