/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.codemodel;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.JsonFormCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.JsonObjectCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.utils.GsonUtils;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class DefaultJsonFormCode
extends JsonObjectCode
implements JsonFormCode {
    public static final String FIELD_EXTRA_CONTENT = "extraContent";
    public static final String FIELD_CONTENT = "content";

    @Override
    public DefaultJsonFormCode parse(String code) {
        try {
            DefaultJsonFormCode obj = (DefaultJsonFormCode)super.parse(code);
            boolean valid = Optional.ofNullable(obj).map(o -> o.getContent() != null || o.getExtraContent() != null).orElse(false);
            if (valid) {
                try {
                    DefaultJsonFormCode jsonFormCode = (DefaultJsonFormCode)GsonUtils.fromJsonString(obj.getContent(), this.getClass());
                    return Optional.ofNullable(jsonFormCode).map(pf -> {
                        pf.setRawContent(obj.getRawContent());
                        return pf.setContent(obj.getContent()).setExtraContent(obj.getExtraContent());
                    }).orElse(this.getDefaultCode(code));
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    return this.getDefaultCode(code);
                }
            }
            DefaultJsonFormCode jsonFormCode = (DefaultJsonFormCode)GsonUtils.fromJsonString(code, this.getClass());
            JSONObject validContent = new JSONObject();
            validContent.fluentPut(FIELD_CONTENT, (Object)code).fluentPut(FIELD_EXTRA_CONTENT, (Object)new JSONObject().toString());
            return Optional.ofNullable(jsonFormCode).map(pf -> this.parse(validContent.toString())).orElse(this.getDefaultCode(validContent.toString()));
        }
        catch (Exception jsonSyntaxException) {
            JSONObject validContent = new JSONObject();
            validContent.fluentPut(FIELD_CONTENT, (Object)code).fluentPut(FIELD_EXTRA_CONTENT, (Object)new JSONObject().toString());
            return this.getDefaultCode(validContent.toString());
        }
    }

    private DefaultJsonFormCode getDefaultCode(String code) {
        DefaultJsonFormCode defaultCode;
        try {
            defaultCode = (DefaultJsonFormCode)this.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        defaultCode.setRawContent(code);
        return defaultCode;
    }

    @Override
    public List<String> getProgramTypes() {
        return Stream.of(CodeProgramType.HOLOGRES_SYNC_DATA, CodeProgramType.HOLOGRES_SYNC_DDL, CodeProgramType.HOLOGRES_SYNC_DATA_TO_MC, CodeProgramType.PAI_STUDIO, CodeProgramType.XLAB).map(Enum::name).distinct().collect(Collectors.toList());
    }

    public DefaultJsonFormCode setExtraContent(String extraContent) {
        Optional.ofNullable(JSON.parseObject((String)this.rawContent)).ifPresent(js -> {
            js.put((Object)FIELD_EXTRA_CONTENT, (Object)extraContent);
            this.rawContent = JSON.toJSONString((Object)js);
        });
        return this;
    }

    public DefaultJsonFormCode setContent(String content) {
        Optional.ofNullable(JSON.parseObject((String)this.rawContent)).ifPresent(js -> {
            js.put((Object)FIELD_CONTENT, (Object)content);
            this.rawContent = JSON.toJSONString((Object)js);
        });
        return this;
    }

    public String getExtraContent() {
        if (StringUtils.isBlank((CharSequence)this.rawContent)) {
            return null;
        }
        return Optional.ofNullable(JSON.parseObject((String)this.rawContent)).map(js -> js.getString(FIELD_EXTRA_CONTENT)).orElse(null);
    }

    @Override
    public String getContent() {
        if (StringUtils.isBlank((CharSequence)this.rawContent)) {
            return null;
        }
        return Optional.ofNullable(JSON.parseObject((String)this.rawContent)).map(js -> js.getString(FIELD_CONTENT)).orElse(null);
    }

    @Override
    public String getRawContent() {
        return this.rawContent;
    }

    @Override
    public void setSourceCode(String sourceCode) {
        DefaultJsonFormCode jsonFormCode = this.parse(sourceCode);
        Optional.ofNullable(jsonFormCode).ifPresent(pc -> super.setSourceCode(pc.getRawContent()));
    }

    @Override
    public String toString() {
        return "DefaultJsonFormCode()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultJsonFormCode)) {
            return false;
        }
        DefaultJsonFormCode other = (DefaultJsonFormCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DefaultJsonFormCode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

