/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.codemodel;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.AbstractBaseCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.JsonFormCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.interfaces.LabelEnum;
import com.aliyun.dataworks.common.spec.utils.GsonUtils;
import com.aliyun.dataworks.common.spec.utils.StringTypeObjectAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ControllerJoinCode
extends AbstractBaseCode
implements JsonFormCode {
    @JsonAdapter(value=StringTypeObjectAdapter.class)
    private List<Branch> branchList;
    private String resultStatus;

    @Override
    public ControllerJoinCode parse(String code) {
        Optional.ofNullable(GsonUtils.fromJsonString(code, new TypeToken<ControllerJoinCode>(){}.getType())).map(m -> (ControllerJoinCode)m).ifPresent(m -> {
            this.setResourceReferences(m.getResourceReferences());
            this.setBranchList(m.getBranchList());
            this.setResultStatus(m.getResultStatus());
        });
        return this;
    }

    @Override
    public Map<String, Object> getTemplate() {
        return null;
    }

    @Override
    public List<String> getProgramTypes() {
        return Collections.singletonList(CodeProgramType.CONTROLLER_JOIN.name());
    }

    public List<Branch> getBranchList() {
        return this.branchList;
    }

    public String getResultStatus() {
        return this.resultStatus;
    }

    public ControllerJoinCode setBranchList(List<Branch> branchList) {
        this.branchList = branchList;
        return this;
    }

    public ControllerJoinCode setResultStatus(String resultStatus) {
        this.resultStatus = resultStatus;
        return this;
    }

    @Override
    public String toString() {
        return "ControllerJoinCode(super=" + super.toString() + ", branchList=" + this.getBranchList() + ", resultStatus=" + this.getResultStatus() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ControllerJoinCode)) {
            return false;
        }
        ControllerJoinCode other = (ControllerJoinCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Branch> this$branchList = this.getBranchList();
        List<Branch> other$branchList = other.getBranchList();
        if (this$branchList == null ? other$branchList != null : !((Object)this$branchList).equals(other$branchList)) {
            return false;
        }
        String this$resultStatus = this.getResultStatus();
        String other$resultStatus = other.getResultStatus();
        return !(this$resultStatus == null ? other$resultStatus != null : !this$resultStatus.equals(other$resultStatus));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ControllerJoinCode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Branch> $branchList = this.getBranchList();
        result = result * 59 + ($branchList == null ? 43 : ((Object)$branchList).hashCode());
        String $resultStatus = this.getResultStatus();
        result = result * 59 + ($resultStatus == null ? 43 : $resultStatus.hashCode());
        return result;
    }

    public static enum Logic implements LabelEnum
    {
        OR("Or", 0),
        AND("And", 1);

        private final String label;
        private final Integer code;

        public static Logic ofCode(Integer code) {
            for (Logic value : Logic.values()) {
                if (!value.getCode().equals(code)) continue;
                return value;
            }
            return null;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        public Integer getCode() {
            return this.code;
        }

        private Logic(String label, Integer code) {
            this.label = label;
            this.code = code;
        }
    }

    public static enum Status implements LabelEnum
    {
        FAILURE("Failure", "0"),
        SUCCESS("Success", "1"),
        NOT_RUN("NotRun", "2");

        private final String label;
        private final String code;

        @Override
        public String getLabel() {
            return this.label;
        }

        public String getCode() {
            return this.code;
        }

        private Status(String label, String code) {
            this.label = label;
            this.code = code;
        }
    }

    public static class Branch {
        private Integer logic;
        private String node;
        private String nodeName;
        private String nodeUuid;
        private String projectIdentifier;
        private List<String> runStatus;

        public Integer getLogic() {
            return this.logic;
        }

        public String getNode() {
            return this.node;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getNodeUuid() {
            return this.nodeUuid;
        }

        public String getProjectIdentifier() {
            return this.projectIdentifier;
        }

        public List<String> getRunStatus() {
            return this.runStatus;
        }

        public Branch setLogic(Integer logic) {
            this.logic = logic;
            return this;
        }

        public Branch setNode(String node) {
            this.node = node;
            return this;
        }

        public Branch setNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public Branch setNodeUuid(String nodeUuid) {
            this.nodeUuid = nodeUuid;
            return this;
        }

        public Branch setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        public Branch setRunStatus(List<String> runStatus) {
            this.runStatus = runStatus;
            return this;
        }

        public String toString() {
            return "ControllerJoinCode.Branch(logic=" + this.getLogic() + ", node=" + this.getNode() + ", nodeName=" + this.getNodeName() + ", nodeUuid=" + this.getNodeUuid() + ", projectIdentifier=" + this.getProjectIdentifier() + ", runStatus=" + this.getRunStatus() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Branch)) {
                return false;
            }
            Branch other = (Branch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$logic = this.getLogic();
            Integer other$logic = other.getLogic();
            if (this$logic == null ? other$logic != null : !((Object)this$logic).equals(other$logic)) {
                return false;
            }
            String this$node = this.getNode();
            String other$node = other.getNode();
            if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
                return false;
            }
            String this$nodeName = this.getNodeName();
            String other$nodeName = other.getNodeName();
            if (this$nodeName == null ? other$nodeName != null : !this$nodeName.equals(other$nodeName)) {
                return false;
            }
            String this$nodeUuid = this.getNodeUuid();
            String other$nodeUuid = other.getNodeUuid();
            if (this$nodeUuid == null ? other$nodeUuid != null : !this$nodeUuid.equals(other$nodeUuid)) {
                return false;
            }
            String this$projectIdentifier = this.getProjectIdentifier();
            String other$projectIdentifier = other.getProjectIdentifier();
            if (this$projectIdentifier == null ? other$projectIdentifier != null : !this$projectIdentifier.equals(other$projectIdentifier)) {
                return false;
            }
            List<String> this$runStatus = this.getRunStatus();
            List<String> other$runStatus = other.getRunStatus();
            return !(this$runStatus == null ? other$runStatus != null : !((Object)this$runStatus).equals(other$runStatus));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Branch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $logic = this.getLogic();
            result = result * 59 + ($logic == null ? 43 : ((Object)$logic).hashCode());
            String $node = this.getNode();
            result = result * 59 + ($node == null ? 43 : $node.hashCode());
            String $nodeName = this.getNodeName();
            result = result * 59 + ($nodeName == null ? 43 : $nodeName.hashCode());
            String $nodeUuid = this.getNodeUuid();
            result = result * 59 + ($nodeUuid == null ? 43 : $nodeUuid.hashCode());
            String $projectIdentifier = this.getProjectIdentifier();
            result = result * 59 + ($projectIdentifier == null ? 43 : $projectIdentifier.hashCode());
            List<String> $runStatus = this.getRunStatus();
            result = result * 59 + ($runStatus == null ? 43 : ((Object)$runStatus).hashCode());
            return result;
        }
    }
}

