/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.codemodel;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.AbstractBaseCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.Code;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.CodeModel;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.PlainTextCode;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeModelFactory {
    private static final Logger log = LoggerFactory.getLogger(CodeModelFactory.class);

    public static <M extends Code> CodeModel<M> getCodeModel(String programType, String content) {
        if (programType == null) {
            return new CodeModel();
        }
        CodeModel<Code> model = new CodeModel<Code>();
        model.setProgramType(programType);
        model.setCodeModel(CodeModelFactory.parseCodeModel(programType, content));
        return model;
    }

    private static Code parseCodeModel(String programType, String code) {
        Reflections reflections = new Reflections(Code.class.getPackage().getName(), new Scanner[0]);
        List list = reflections.getSubTypesOf(AbstractBaseCode.class).stream().filter(subType -> !Modifier.isAbstract(subType.getModifiers()) && !Modifier.isInterface(subType.getModifiers())).map(subType -> {
            try {
                return (AbstractBaseCode)subType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }).filter(inst -> inst.support(programType)).collect(Collectors.toList());
        log.debug("code model list: {}", list);
        Code theOne = list.stream().peek(inst -> inst.setProgramType(programType)).max(Comparator.comparing(AbstractBaseCode::getClassHierarchyLevel)).map(inst -> inst.parse(code)).orElseGet(() -> {
            PlainTextCode c = new PlainTextCode();
            c.setProgramType(programType);
            c.parse(code);
            return c;
        });
        log.debug("code model: {}", (Object)theOne);
        return theOne;
    }
}

