/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.codemodel;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.Code;
import com.aliyun.dataworks.common.spec.utils.ClassUtils;
import com.aliyun.dataworks.common.spec.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public abstract class AbstractBaseCode
implements Code {
    protected List<String> resourceReferences;
    protected transient String programType;

    @Override
    public String getRawContent() {
        return this.getContent();
    }

    @Override
    public String getContent() {
        return GsonUtils.toJsonString(this);
    }

    @Override
    public List<String> getResourceReferences() {
        return this.resourceReferences;
    }

    @Override
    public String getSourceCode() {
        return this.getContent();
    }

    @Override
    public void setSourceCode(String sourceCode) {
    }

    @Override
    public Map<String, Object> getTemplate() {
        Code c = this.parse(this.getContent());
        c.setSourceCode("");
        String content = c.getContent();
        return (Map)GsonUtils.fromJsonString(content, new TypeToken<Map<String, Object>>(){}.getType());
    }

    @Override
    public void setProgramType(String programType) {
        this.programType = programType;
    }

    @Override
    public int getClassHierarchyLevel() {
        return ClassUtils.getClassHierarchyLevel(this);
    }

    public String getProgramType() {
        return this.programType;
    }

    public AbstractBaseCode setResourceReferences(List<String> resourceReferences) {
        this.resourceReferences = resourceReferences;
        return this;
    }

    public String toString() {
        return "AbstractBaseCode(super=" + super.toString() + ", resourceReferences=" + this.getResourceReferences() + ", programType=" + this.getProgramType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractBaseCode)) {
            return false;
        }
        AbstractBaseCode other = (AbstractBaseCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$resourceReferences = this.getResourceReferences();
        List<String> other$resourceReferences = other.getResourceReferences();
        return !(this$resourceReferences == null ? other$resourceReferences != null : !((Object)this$resourceReferences).equals(other$resourceReferences));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractBaseCode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $resourceReferences = this.getResourceReferences();
        result = result * 59 + ($resourceReferences == null ? 43 : ((Object)$resourceReferences).hashCode());
        return result;
    }
}

