/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.task;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;

public class TaskExecutionContextCacheManager {
    private static Map<Integer, TaskRequest> taskRequestContextCache = new ConcurrentHashMap<Integer, TaskRequest>();

    private TaskExecutionContextCacheManager() {
        throw new IllegalStateException("Utility class");
    }

    public static TaskRequest getByTaskInstanceId(Integer taskInstanceId) {
        return taskRequestContextCache.get(taskInstanceId);
    }

    public static void cacheTaskExecutionContext(TaskRequest request) {
        taskRequestContextCache.put(request.getTaskInstanceId(), request);
    }

    public static void removeByTaskInstanceId(Integer taskInstanceId) {
        taskRequestContextCache.remove(taskInstanceId);
    }

    public static boolean updateTaskExecutionContext(TaskRequest request) {
        taskRequestContextCache.computeIfPresent(request.getTaskInstanceId(), (k, v) -> request);
        return taskRequestContextCache.containsKey(request.getTaskInstanceId());
    }
}

