/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.task;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.spi.task.Direct;
import org.apache.dolphinscheduler.spi.task.IParameters;
import org.apache.dolphinscheduler.spi.task.Property;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;

public abstract class AbstractParameters
implements IParameters {
    protected List<Property> localParams;
    public List<Property> varPool;

    public List<Property> getLocalParams() {
        return this.localParams;
    }

    public void setLocalParams(List<Property> localParams) {
        this.localParams = localParams;
    }

    public Map<String, Property> getLocalParametersMap() {
        if (this.localParams != null) {
            LinkedHashMap<String, Property> localParametersMaps = new LinkedHashMap<String, Property>();
            for (Property property : this.localParams) {
                localParametersMaps.put(property.getProp(), property);
            }
            return localParametersMaps;
        }
        return null;
    }

    public Map<String, Property> getVarPoolMap() {
        if (this.varPool != null) {
            LinkedHashMap<String, Property> varPoolMap = new LinkedHashMap<String, Property>();
            for (Property property : this.varPool) {
                varPoolMap.put(property.getProp(), property);
            }
            return varPoolMap;
        }
        return null;
    }

    public List<Property> getVarPool() {
        return this.varPool;
    }

    public void setVarPool(String varPool) {
        this.varPool = StringUtils.isEmpty(varPool) ? new ArrayList<Property>() : JSONUtils.toList(varPool, Property.class);
    }

    public void dealOutParam(String result) {
        if (CollectionUtils.isEmpty(this.localParams)) {
            return;
        }
        List<Property> outProperty = this.getOutProperty(this.localParams);
        if (CollectionUtils.isEmpty(outProperty)) {
            return;
        }
        if (StringUtils.isEmpty(result)) {
            this.varPool.addAll(outProperty);
            return;
        }
        Map<String, String> taskResult = AbstractParameters.getMapByString(result);
        if (taskResult == null || taskResult.size() == 0) {
            return;
        }
        for (Property info : outProperty) {
            info.setValue(taskResult.get(info.getProp()));
            this.varPool.add(info);
        }
    }

    public List<Property> getOutProperty(List<Property> params) {
        if (CollectionUtils.isEmpty(params)) {
            return new ArrayList<Property>();
        }
        ArrayList<Property> result = new ArrayList<Property>();
        for (Property info : params) {
            if (info.getDirect() != Direct.OUT) continue;
            result.add(info);
        }
        return result;
    }

    public List<Map<String, String>> getListMapByString(String json) {
        ArrayList<Map<String, String>> allParams = new ArrayList<Map<String, String>>();
        ArrayNode paramsByJson = JSONUtils.parseArray(json);
        for (JsonNode jsonNode : paramsByJson) {
            Map<String, String> param = JSONUtils.toMap(jsonNode.toString());
            allParams.add(param);
        }
        return allParams;
    }

    public static Map<String, String> getMapByString(String result) {
        String[] formatResult = result.split("\\$VarPool\\$");
        HashMap<String, String> format = new HashMap<String, String>();
        for (String info : formatResult) {
            if (!StringUtils.isNotEmpty(info) || !info.contains("=")) continue;
            String[] keyValue = info.split("=");
            format.put(keyValue[0], keyValue[1]);
        }
        return format;
    }
}

