/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.oss;

import com.aliyun.migration.teleport.cloud.enums.DeployEnv;
import java.util.Map;

public class OssEndpoint {
    private String region;
    private String vpcEndpoint;
    private String publicEndpoint;
    private String bucket;
    private String artifactBucket;
    private static final OssEndpoint cn_hangzhou_local = new OssEndpoint("cn-hangzhou", "oss-cn-hangzhou-internal.aliyuncs.com", "oss-cn-hangzhou.aliyuncs.com", "lhm-waixi-qx-test", "lhm-waixi-qx-test");
    private static final OssEndpoint cn_hangzhou_pre = new OssEndpoint("cn-hangzhou", "oss-cn-hangzhou-internal.aliyuncs.com", "oss-cn-hangzhou.aliyuncs.com", "lhm-pre-cn-hangzhou", "lhm-pre-cn-hangzhou-artifacts");
    private static final OssEndpoint cn_hangzhou_prod = new OssEndpoint("cn-hangzhou", "oss-cn-hangzhou-internal.aliyuncs.com", "oss-cn-hangzhou.aliyuncs.com", "lhm-prod-cn-hangzhou", "lhm-prod-cn-hangzhou-artifacts");
    private static final OssEndpoint ap_southeast_1_pre = new OssEndpoint("ap-southeast-1", "oss-ap-southeast-1-internal.aliyuncs.com", "oss-ap-southeast-1.aliyuncs.com", "lhm-pre-southeast", "lhm-pre-southeast-artifacts");
    private static final OssEndpoint ap_southeast_1_prod = new OssEndpoint("ap-southeast-1", "oss-ap-southeast-1-internal.aliyuncs.com", "oss-ap-southeast-1.aliyuncs.com", "lhm-prod-southeast", "lhm-prod-southeast-artifacts");
    private static final Map<String, OssEndpoint> endpoints = Map.of("cn-hangzhou.local", cn_hangzhou_local, "cn-hangzhou.pre", cn_hangzhou_pre, "cn-hangzhou.prod", cn_hangzhou_prod, "ap-southeast-1.pre", ap_southeast_1_pre, "ap-southeast-1.prod", ap_southeast_1_prod);

    private OssEndpoint(String region, String vpcEndpoint, String publicEndpoint, String bucket, String artifactBucket) {
        this.region = region;
        this.vpcEndpoint = vpcEndpoint;
        this.publicEndpoint = publicEndpoint;
        this.bucket = bucket;
        this.artifactBucket = artifactBucket;
    }

    public static OssEndpoint of(String region, DeployEnv env) {
        String key = String.format("%s.%s", region, env.getValue());
        OssEndpoint endpoint = endpoints.get(key);
        if (endpoint == null) {
            return OssEndpoint.buildDefaultEndpoint(region, env);
        }
        return endpoint;
    }

    private static OssEndpoint buildDefaultEndpoint(String region, DeployEnv env) {
        return new OssEndpoint(region, String.format("oss-%s-internal.aliyuncs.com", region), String.format("oss-%s.aliyuncs.com", region), String.format("lhm-%s-%s", env.getValue(), region), String.format("lhm-%s-%s-artifacts", env.getValue(), region));
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public void setVpcEndpoint(String vpcEndpoint) {
        this.vpcEndpoint = vpcEndpoint;
    }

    public String getVpcEndpoint() {
        return this.vpcEndpoint;
    }

    public void setPublicEndpoint(String publicEndpoint) {
        this.publicEndpoint = publicEndpoint;
    }

    public String getPublicEndpoint() {
        return this.publicEndpoint;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setArtifactBucket(String artifactBucket) {
        this.artifactBucket = artifactBucket;
    }

    public String getArtifactBucket() {
        return this.artifactBucket;
    }
}

