/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.enums;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public enum EnvEnums {
    LHM_OSS_AK("oss access key id"),
    LHM_OSS_SK("oss access key secret"),
    LHM_OSS_ENDPOINT("oss endpoint"),
    LHM_OSS_BUCKET("oss bucket"),
    LHM_DW_AK("dataworks access key id"),
    LHM_DW_SK("dataworks access key secret"),
    LHM_STS_UID("sts user id"),
    LHM_STS_AK("sts access key id"),
    LHM_STS_SK("sts access key secret"),
    LHM_STS_ROLE("sts role name"),
    LHM_MNS_AK("mns access key id"),
    LHM_MNS_SK("mns access key secret");

    private static final Logger log;
    private String desc;

    private EnvEnums(String desc) {
        this.desc = desc;
    }

    public static String getValue(EnvEnums env, String defaultValue) {
        String envValue = EnvEnums.getValue(env);
        return StringUtils.hasText((String)envValue) ? envValue : defaultValue;
    }

    public static String getValue(EnvEnums env) {
        return System.getenv(env.name());
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        log = LoggerFactory.getLogger(EnvEnums.class);
    }
}

