/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.entity;

import com.aliyun.migration.teleport.cloud.entity.CallbackProperties;
import com.aliyun.migration.teleport.cloud.enums.CloudAccessType;
import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;
import com.aliyun.migration.teleport.common.utils.PasswordUtil;
import java.io.Serializable;
import org.springframework.util.StringUtils;

public class SinkProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CloudAccessType loginType;
    private String accessKeyId;
    private String accessKeySecret;
    private String securityToken;
    private String encryptIv;
    private String endpoint;
    private String regionId;
    private String bucket;

    public CallbackProperties toCallbackProperties() {
        return CallbackProperties.builder().loginType(this.loginType).accessKeyId(this.accessKeyId).accessKeySecret(this.accessKeySecret).securityToken(this.securityToken).encryptIv(this.encryptIv).endpoint(this.endpoint).regionId(this.regionId).topicName(this.bucket).build();
    }

    public SinkProperties encrypt() {
        try {
            this.encryptIv = PasswordUtil.getSecretKeyBase64();
            PasswordUtil.EncryptEntity encryptEntity = PasswordUtil.encryptWithAes256((String)this.accessKeySecret, (String)this.encryptIv);
            this.accessKeySecret = encryptEntity.getEncryptContent();
        }
        catch (Exception e) {
            this.encryptIv = null;
        }
        return this;
    }

    public void decrypt() {
        if (StringUtils.hasText((String)this.encryptIv)) {
            this.accessKeySecret = PasswordUtil.decryptWithAes256((String)this.accessKeySecret, (String)this.encryptIv);
            this.encryptIv = null;
        }
    }

    public void validate() {
        if (!StringUtils.hasText((String)this.accessKeyId) || !StringUtils.hasText((String)this.accessKeySecret)) {
            throw new TeleportException(TeleportStatusCode.PARAM_NOT_VALID, "accessKeyId or accessKeySecret is blank");
        }
    }

    public static SinkPropertiesBuilder builder() {
        return new SinkPropertiesBuilder();
    }

    public CloudAccessType getLoginType() {
        return this.loginType;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public String getEncryptIv() {
        return this.encryptIv;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setLoginType(CloudAccessType loginType) {
        this.loginType = loginType;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public void setEncryptIv(String encryptIv) {
        this.encryptIv = encryptIv;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinkProperties)) {
            return false;
        }
        SinkProperties other = (SinkProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CloudAccessType this$loginType = this.getLoginType();
        CloudAccessType other$loginType = other.getLoginType();
        if (this$loginType == null ? other$loginType != null : !((Object)((Object)this$loginType)).equals((Object)other$loginType)) {
            return false;
        }
        String this$accessKeyId = this.getAccessKeyId();
        String other$accessKeyId = other.getAccessKeyId();
        if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
            return false;
        }
        String this$accessKeySecret = this.getAccessKeySecret();
        String other$accessKeySecret = other.getAccessKeySecret();
        if (this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret)) {
            return false;
        }
        String this$securityToken = this.getSecurityToken();
        String other$securityToken = other.getSecurityToken();
        if (this$securityToken == null ? other$securityToken != null : !this$securityToken.equals(other$securityToken)) {
            return false;
        }
        String this$encryptIv = this.getEncryptIv();
        String other$encryptIv = other.getEncryptIv();
        if (this$encryptIv == null ? other$encryptIv != null : !this$encryptIv.equals(other$encryptIv)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$regionId = this.getRegionId();
        String other$regionId = other.getRegionId();
        if (this$regionId == null ? other$regionId != null : !this$regionId.equals(other$regionId)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        return !(this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SinkProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CloudAccessType $loginType = this.getLoginType();
        result = result * 59 + ($loginType == null ? 43 : ((Object)((Object)$loginType)).hashCode());
        String $accessKeyId = this.getAccessKeyId();
        result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
        String $accessKeySecret = this.getAccessKeySecret();
        result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
        String $securityToken = this.getSecurityToken();
        result = result * 59 + ($securityToken == null ? 43 : $securityToken.hashCode());
        String $encryptIv = this.getEncryptIv();
        result = result * 59 + ($encryptIv == null ? 43 : $encryptIv.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $regionId = this.getRegionId();
        result = result * 59 + ($regionId == null ? 43 : $regionId.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        return result;
    }

    public String toString() {
        return "SinkProperties(loginType=" + String.valueOf((Object)this.getLoginType()) + ", accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", securityToken=" + this.getSecurityToken() + ", encryptIv=" + this.getEncryptIv() + ", endpoint=" + this.getEndpoint() + ", regionId=" + this.getRegionId() + ", bucket=" + this.getBucket() + ")";
    }

    public SinkProperties() {
    }

    public SinkProperties(CloudAccessType loginType, String accessKeyId, String accessKeySecret, String securityToken, String encryptIv, String endpoint, String regionId, String bucket) {
        this.loginType = loginType;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.securityToken = securityToken;
        this.encryptIv = encryptIv;
        this.endpoint = endpoint;
        this.regionId = regionId;
        this.bucket = bucket;
    }

    public static class SinkPropertiesBuilder {
        private CloudAccessType loginType;
        private String accessKeyId;
        private String accessKeySecret;
        private String securityToken;
        private String encryptIv;
        private String endpoint;
        private String regionId;
        private String bucket;

        SinkPropertiesBuilder() {
        }

        public SinkPropertiesBuilder loginType(CloudAccessType loginType) {
            this.loginType = loginType;
            return this;
        }

        public SinkPropertiesBuilder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public SinkPropertiesBuilder accessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
            return this;
        }

        public SinkPropertiesBuilder securityToken(String securityToken) {
            this.securityToken = securityToken;
            return this;
        }

        public SinkPropertiesBuilder encryptIv(String encryptIv) {
            this.encryptIv = encryptIv;
            return this;
        }

        public SinkPropertiesBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public SinkPropertiesBuilder regionId(String regionId) {
            this.regionId = regionId;
            return this;
        }

        public SinkPropertiesBuilder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public SinkProperties build() {
            return new SinkProperties(this.loginType, this.accessKeyId, this.accessKeySecret, this.securityToken, this.encryptIv, this.endpoint, this.regionId, this.bucket);
        }

        public String toString() {
            return "SinkProperties.SinkPropertiesBuilder(loginType=" + String.valueOf((Object)this.loginType) + ", accessKeyId=" + this.accessKeyId + ", accessKeySecret=" + this.accessKeySecret + ", securityToken=" + this.securityToken + ", encryptIv=" + this.encryptIv + ", endpoint=" + this.endpoint + ", regionId=" + this.regionId + ", bucket=" + this.bucket + ")";
        }
    }
}

