/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.teleport.cloud.data.loader;

import com.aliyun.migration.teleport.cloud.client.DataLoader;
import com.aliyun.migration.teleport.cloud.entity.SinkProperties;
import com.aliyun.migration.teleport.cloud.oss.OssClient;
import com.aliyun.migration.teleport.cloud.utils.IdGenerator;
import com.aliyun.migration.teleport.common.constants.TeleportStatusCode;
import com.aliyun.migration.teleport.common.exceptions.TeleportException;
import com.baomidou.mybatisplus.extension.toolkit.SqlRunner;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractStarRocksDataLoader<T>
implements DataLoader<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractStarRocksDataLoader.class);
    private static final String MULTI_BROKER_LOAD_SQL = "LOAD LABEL %s (\n          %s\n        )\n        WITH\n          BROKER (\n            \"fs.oss.accessKeyId\" = \"%s\",\n            \"fs.oss.accessKeySecret\" = \"%s\",\n            \"fs.oss.endpoint\" = \"%s\"\n          )\n          PROPERTIES\n          (\n              \"timeout\" = \"3600\"\n          );";
    private static final String BROKER_LOAD_DATA_DESC = "DATA INFILE (\"%s\") INTO TABLE %s format as \"json\"";
    private static final String OSS_PROTOCOL = "oss://";
    protected SinkProperties ossProperties;
    protected int maxAttempts;
    protected int delayIntervalMs;

    @Override
    public void init(SinkProperties ossProperties) {
        this.ossProperties = ossProperties;
        this.maxAttempts = 10;
        this.delayIntervalMs = 1000;
    }

    public abstract Map<String, String> getTableObjectPathMapping(T var1);

    @Override
    public void load(T message, String userId, String loadTaskPrefix) {
        OssClient ossClient = new OssClient(this.ossProperties);
        List<String> dataDescList = this.getValidateDataDescList(this.getTableObjectPathMapping(message), this.ossProperties.getBucket(), userId, ossClient);
        String prefix = "";
        if (StringUtils.hasText((String)loadTaskPrefix)) {
            prefix = loadTaskPrefix;
        }
        String label = prefix + IdGenerator.generateUUID();
        this.multiBrokerLoad(label, dataDescList);
        this.waitLoadSuccess(label);
    }

    private List<String> getValidateDataDescList(Map<String, String> tableObjectMapping, String ossBucket, String uid, OssClient ossClient) {
        return tableObjectMapping.entrySet().stream().filter(entry -> ossClient.isFileExists((String)entry.getValue(), uid)).map(entry -> String.format(BROKER_LOAD_DATA_DESC, OSS_PROTOCOL + ossBucket + "/" + (String)entry.getValue(), entry.getKey())).toList();
    }

    private void multiBrokerLoad(String label, List<String> dataDescList) {
        String dataDesc = String.join((CharSequence)",\n", dataDescList);
        String sql = String.format(MULTI_BROKER_LOAD_SQL, label, dataDesc, this.ossProperties.getAccessKeyId(), this.ossProperties.getAccessKeySecret(), this.ossProperties.getEndpoint());
        String sqlLog = String.format(MULTI_BROKER_LOAD_SQL, label, dataDesc, "******", "******", this.ossProperties.getEndpoint());
        log.info("[BrokerLoad] SQL:{}", (Object)sqlLog);
        SqlRunner.db().update(sql, new Object[0]);
    }

    private void waitLoadSuccess(String label) {
        for (int attempt = 0; attempt < this.maxAttempts; ++attempt) {
            List<Map<String, Object>> loads = this.getLoads(label);
            if (CollectionUtils.isEmpty(loads)) {
                log.error("[BrokerLoad] load empty, label={}", (Object)label);
                throw new TeleportException(TeleportStatusCode.SR_BROKER_LOAD_EMPTY);
            }
            for (Map<String, Object> load : loads) {
                String state = (String)load.get("STATE");
                if (StarRocksLoadStatus.isSuccess(state)) {
                    log.info("[BrokerLoad] load success, label={}", (Object)label);
                    return;
                }
                if (!StarRocksLoadStatus.isFailed(state)) continue;
                String message = (String)load.get("ERROR_MSG");
                String trackSql = (String)load.get("TRACKING_SQL");
                log.error("[BrokerLoad] load failed, message: {}, trackingSql: {}", (Object)message, (Object)trackSql);
                throw new TeleportException(TeleportStatusCode.SR_BROKER_LOAD_FAILED, message);
            }
            if (attempt >= this.maxAttempts - 1) continue;
            long delay = (long)Math.pow(2.0, attempt) * (long)this.delayIntervalMs;
            log.info("[BrokerLoad] attempt {}/{} failed, waiting {}ms before retry", new Object[]{attempt + 1, this.maxAttempts, delay});
            try {
                Thread.sleep(delay);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("[BrokerLoad] interrupted during retry delay", (Throwable)e);
                throw new TeleportException(TeleportStatusCode.SR_LOAD_INTERRUPT, (Throwable)e);
            }
        }
        String errorMsg = "[BrokerLoad] load check failed after " + this.maxAttempts + " attempts";
        log.error(errorMsg);
        throw new TeleportException(TeleportStatusCode.SR_BROKER_LOAD_TIMEOUT);
    }

    private List<Map<String, Object>> getLoads(String label) {
        List loads = SqlRunner.db().selectList("select * from information_schema.loads where LABEL={0}", new Object[]{label});
        if (CollectionUtils.isEmpty((Collection)loads)) {
            return List.of();
        }
        return loads;
    }

    public void setOssProperties(SinkProperties ossProperties) {
        this.ossProperties = ossProperties;
    }

    public SinkProperties getOssProperties() {
        return this.ossProperties;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setDelayIntervalMs(int delayIntervalMs) {
        this.delayIntervalMs = delayIntervalMs;
    }

    public int getDelayIntervalMs() {
        return this.delayIntervalMs;
    }

    public static enum StarRocksLoadStatus {
        PENDING,
        QUEUEING,
        LOADING,
        PREPARED,
        FINISHED,
        CANCELLED;


        public static boolean isFailed(String status) {
            return CANCELLED.name().equals(status);
        }

        public static boolean isSuccess(String status) {
            return FINISHED.name().equals(status);
        }
    }
}

