/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.hue.service;

import com.alibaba.cola.dto.Response;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.hue.domain.HueBaseBean;
import com.aliyun.migration.workflow.migration.hue.domain.HuePackage;
import com.aliyun.migration.workflow.migration.hue.domain.HueProject;
import com.aliyun.migration.workflow.migration.hue.domain.HueSchedule;
import com.aliyun.migration.workflow.migration.hue.domain.HueScript;
import com.aliyun.migration.workflow.migration.hue.domain.HueWorkflow;
import com.aliyun.migrationx.common.utils.ZipUtils;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class HuePackageLoader {
    private static final Logger log = LoggerFactory.getLogger(HuePackageLoader.class);

    public static Response validateHuePackageDir(String huePackagePath) {
        File realDir;
        File rootFile = new File(huePackagePath);
        if (!rootFile.exists()) {
            log.error("hue root package is null , please check path");
            return Response.buildFailure((String)BwmServiceErrorCode.FILE_NOT_FOUND.getCode(), (String)"hue root package is null , please check path");
        }
        try {
            realDir = HuePackageLoader.getRealDir(new File(huePackagePath));
        }
        catch (IOException e) {
            log.error("get root dir error", (Throwable)e);
            return Response.buildFailure((String)BwmServiceErrorCode.FILE_NOT_FOUND.getCode(), (String)"gget root dir error, please check path");
        }
        File workflowsDir = new File(realDir, "workflows");
        if (!workflowsDir.exists()) {
            log.error("hue workflow dir not found");
            return Response.buildFailure((String)BwmServiceErrorCode.FILE_NOT_FOUND.getCode(), (String)"hue workflow dir not found,please check path");
        }
        File schedulesDir = new File(realDir, "schedules");
        if (!schedulesDir.exists()) {
            log.error("hue schedule dir not found");
            return Response.buildFailure((String)BwmServiceErrorCode.FILE_NOT_FOUND.getCode(), (String)"hue schedule dir not found,please check path");
        }
        File scriptsDir = new File(realDir, "scripts");
        if (!scriptsDir.exists()) {
            log.error("hue scripts dir not found");
            return Response.buildFailure((String)BwmServiceErrorCode.FILE_NOT_FOUND.getCode(), (String)"hue scripts dir not found,please check path");
        }
        return Response.buildSuccess();
    }

    private static File getRealDir(File rootFile) throws IOException {
        File unzippedDir = rootFile.isFile() ? ZipUtils.decompress((File)rootFile) : rootFile;
        return unzippedDir;
    }

    public static HuePackage load(String huePackagePath) throws IOException {
        File rootFile = new File(huePackagePath);
        if (!rootFile.exists()) {
            log.error("hue root package is null , please check path");
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.FILE_NOT_FOUND);
        }
        File unzippedDir = HuePackageLoader.getRealDir(rootFile);
        HuePackage huePackage = HuePackageLoader.loadPackage(unzippedDir);
        return huePackage;
    }

    private static HuePackage loadPackage(File unzippedDir) throws IOException {
        HuePackage huePackage = new HuePackage();
        File projectFile = new File(unzippedDir, "project.json");
        HueProject hueProject = HuePackageLoader.readProject(projectFile);
        huePackage.setProject(hueProject);
        File workflowsDir = new File(unzippedDir, "workflows");
        List<HueWorkflow> workflowList = HuePackageLoader.readWorkflows(workflowsDir);
        huePackage.setWorkflows(workflowList);
        File schedulesDir = new File(unzippedDir, "schedules");
        List<HueSchedule> hueSchdules = HuePackageLoader.readSchedules(schedulesDir);
        huePackage.setHueSchdules(hueSchdules);
        File scriptsDir = new File(unzippedDir, "scripts");
        List<HueScript> hueScripts = HuePackageLoader.readScripts(scriptsDir);
        huePackage.setHueScripts(hueScripts);
        return huePackage;
    }

    private static HueProject readProject(File projectFile) throws IOException {
        if (projectFile.exists()) {
            String projectStr = FileUtils.readFileToString((File)projectFile, (Charset)Charsets.UTF_8);
            return (HueProject)BwmJsonUtil.parseObject((String)projectStr, HueProject.class);
        }
        return HueProject.builder().id("0").name("default").description("default project").build();
    }

    private static List<HueWorkflow> readWorkflows(File workflowsDir) throws IOException {
        ArrayList<HueWorkflow> res = new ArrayList<HueWorkflow>();
        File[] files = workflowsDir.listFiles(pathname -> pathname.getName().endsWith(".json"));
        if (files == null || files.length <= 0) {
            log.warn("not found hueworkflows file");
            return res;
        }
        File file = files[0];
        String workflowsStr = FileUtils.readFileToString((File)file, (Charset)Charsets.UTF_8);
        JSONArray workflowArr = JSON.parseArray((String)workflowsStr);
        for (int i = 0; i < workflowArr.size(); ++i) {
            String workflowJson = workflowArr.getString(i);
            HueBaseBean baseBean = (HueBaseBean)BwmJsonUtil.parseObject((String)workflowJson, HueBaseBean.class);
            if (Objects.isNull(baseBean)) {
                log.error("parse hue workflow failed, result is null {}", (Object)workflowJson);
                continue;
            }
            HueBaseBean.HueBaseField fields = baseBean.getFields();
            if (Objects.isNull(fields)) {
                log.warn("parse hue workflow failed, result is null {}", (Object)workflowJson);
                continue;
            }
            String data = fields.getData();
            HueWorkflow hueWorkflow = (HueWorkflow)BwmJsonUtil.parseObject((String)data, HueWorkflow.class);
            res.add(hueWorkflow);
        }
        return res;
    }

    private static List<HueSchedule> readSchedules(File schedulesDir) throws IOException {
        ArrayList<HueSchedule> res = new ArrayList<HueSchedule>();
        File[] files = schedulesDir.listFiles(pathname -> pathname.getName().endsWith(".json"));
        if (files == null || files.length <= 0) {
            log.warn("not found hueworkflows file");
            return res;
        }
        File file = files[0];
        String hueSchedulesStrs = FileUtils.readFileToString((File)file, (Charset)Charsets.UTF_8);
        JSONArray hueSchedulesArr = JSON.parseArray((String)hueSchedulesStrs);
        for (int i = 0; i < hueSchedulesArr.size(); ++i) {
            String hueSchedulesStr = hueSchedulesArr.getString(i);
            HueBaseBean baseBean = (HueBaseBean)BwmJsonUtil.parseObject((String)hueSchedulesStr, HueBaseBean.class);
            if (Objects.isNull(baseBean)) {
                log.error("parse hue workflow failed, result is null {}", (Object)hueSchedulesStr);
                continue;
            }
            HueBaseBean.HueBaseField fields = baseBean.getFields();
            if (Objects.isNull(fields)) {
                log.warn("parse hue workflow failed, result is null {}", (Object)hueSchedulesStr);
                continue;
            }
            String data = fields.getData();
            HueSchedule hueWorkflow = (HueSchedule)BwmJsonUtil.parseObject((String)data, HueSchedule.class);
            res.add(hueWorkflow);
        }
        return res;
    }

    private static List<HueScript> readScripts(File scriptDir) {
        ArrayList<HueScript> res = new ArrayList<HueScript>();
        Collection files = FileUtils.listFiles((File)scriptDir, null, (boolean)true);
        if (CollectionUtils.isEmpty((Collection)files)) {
            log.warn("");
            return res;
        }
        files.forEach(x -> {
            try {
                String content = FileUtils.readFileToString((File)x, (Charset)Charsets.UTF_8);
                String path = x.getPath();
                String name = x.getName();
                HueScript build = HueScript.builder().name(name).content(content).path(path).build();
                res.add(build);
            }
            catch (IOException e) {
                log.error("read file to Str error {}", (Object)x.getName(), (Object)e);
            }
        });
        return res;
    }
}

