/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv1.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.shell.ShellParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(ShellNodeConvert.class);

    public ShellNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        String nodeType = this.getNodeType(workflowNode);
        tgtworkflowNode.setNodeType(nodeType);
        if (workflowNode.getScriptPath() == null || workflowNode.getScriptPath().endsWith(".json")) {
            ShellParameters parameter = (ShellParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(ShellParameters.class).getType());
            List resources = ListUtils.emptyIfNull((List)parameter.getResourceFilesList()).stream().map(ResourceInfo::getName).distinct().collect(Collectors.toList());
            ArrayList<String> codeLines = new ArrayList<String>();
            codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)nodeType), (String)"", resources));
            if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.DIDE_SHELL.name(), (CharSequence)nodeType)) {
                HashMap paramMap = new HashMap();
                ListUtils.emptyIfNull((List)parameter.getLocalParams()).forEach(x -> {
                    String prop = x.getProp();
                    String value = x.getValue();
                    paramMap.put(prop, value);
                });
                tgtworkflowNode.setParamMap(paramMap);
                String codeArgPredefine = ListUtils.emptyIfNull((List)parameter.getLocalParams()).stream().map(property -> property.getProp() + "=" + property.getValue()).collect(Collectors.joining("\n"));
                codeLines.add(codeArgPredefine);
            }
            codeLines.add(parameter.getRawScript());
            tgtworkflowNode.setScript(Joiner.on((String)"\n").join(codeLines));
        } else {
            ArrayList<String> codeLines = new ArrayList<String>();
            ArrayList resources = new ArrayList();
            if (workflowNode.getFiles() != null) {
                workflowNode.getFiles().forEach(file -> {
                    if (StringUtils.isNotBlank((CharSequence)file.getName())) {
                        resources.add(file.getName());
                    }
                });
            }
            codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)nodeType), (String)"", resources));
            if (workflowNode.getParamMap() != null) {
                workflowNode.getParamMap().forEach((k, v) -> codeLines.add(k + "=" + v));
            }
            codeLines.add(workflowNode.getScript());
            tgtworkflowNode.setScript(Joiner.on((String)"\n").join(codeLines));
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)CodeProgramType.EMR_SHELL.name(), (CharSequence)tgtworkflowNode.getNodeType())) {
            tgtworkflowNode.setScript(ShellNodeConvert.wfToEmrCode((WorkflowNode)tgtworkflowNode));
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.shellNodeType", CodeProgramType.DIDE_SHELL.name());
    }
}

