/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv1.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.workflow.migration.common.convert.FunctionConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsV1FunConvert
extends FunctionConvert {
    private static final Logger log = LoggerFactory.getLogger(DsV1FunConvert.class);

    public DsV1FunConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public WorkflowFunctionResource convert(WorkflowFunctionResource workflowFunctionResource) {
        WorkflowFunctionResource function = (WorkflowFunctionResource)BwmJsonUtil.deepCopy((Object)workflowFunctionResource, WorkflowFunctionResource.class);
        String targetEngine = this.getTargetEngineTypeStr(this.taskContext);
        if (targetEngine.equals("EMR")) {
            function.setType(CodeProgramType.EMR_FUNCTION.getName());
            if (function.getCustomProperties() == null) {
                function.setCustomProperties(new HashMap());
            }
            function.getCustomProperties().put("workflow.converter.target.engine.datasource.name", this.getTargetEngineNameStr(this.taskContext));
        } else if (targetEngine.equals("MaxCompute")) {
            function.setType(CodeProgramType.ODPS_FUNCTION.getName());
            if (function.getCustomProperties() == null) {
                function.setCustomProperties(new HashMap());
            }
            function.getCustomProperties().put("workflow.converter.target.engine.datasource.name", this.getTargetEngineNameStr(this.taskContext));
        } else if (targetEngine.equals("CDH")) {
            function.setType(CodeProgramType.CDH_FUNCTION.getName());
            if (function.getCustomProperties() == null) {
                function.setCustomProperties(new HashMap());
            }
            function.getCustomProperties().put("workflow.converter.target.engine.datasource.name", this.getTargetEngineNameStr(this.taskContext));
        } else {
            log.warn("\u672a\u80fd\u8bc6\u522b\u5f15\u64ce\uff0cworkflow.converter.target.engine.type\u5f53\u524d\u8bbe\u7f6e\u4e3a{}\uff0c\u5bfc\u81f4\u8d44\u6e90\u6587\u4ef6\u7c7b\u578b\u5b9a\u4e49\u5931\u8d25", (Object)targetEngine);
        }
        return function;
    }
}

