/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv1.convert;

import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.TaskNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.enums.TaskType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFunctionResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvertFactory;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.convert.DefaultNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.workflow.migration.transform.dw.dsv1.convert.ConditionsNodeConvert;
import com.workflow.migration.transform.dw.dsv1.convert.DataxNodeConvert;
import com.workflow.migration.transform.dw.dsv1.convert.DependentNodeConvert;
import com.workflow.migration.transform.dw.dsv1.convert.DsV1FileConvert;
import com.workflow.migration.transform.dw.dsv1.convert.DsV1FunConvert;
import com.workflow.migration.transform.dw.dsv1.convert.MrNodeConvert;
import com.workflow.migration.transform.dw.dsv1.convert.PyNodeConvert;
import com.workflow.migration.transform.dw.dsv1.convert.ShellNodeConvert;
import com.workflow.migration.transform.dw.dsv1.convert.SparkNodeConvert;
import com.workflow.migration.transform.dw.dsv1.convert.SqlNodeConvert;
import com.workflow.migration.transform.dw.dsv1.convert.SqoopNodeConvert;
import com.workflow.migration.transform.dw.dsv1.convert.SubProcessNodeConvert;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinV1ConvertFactory
extends AbstractConvertFactory {
    private static final Logger log = LoggerFactory.getLogger(DolphinV1ConvertFactory.class);

    public AbstractConvert<WorkflowFunctionResource> getFunctionConvert(TaskContext taskContext) {
        return new DsV1FunConvert(taskContext);
    }

    public AbstractConvert<WorkflowFileResource> getFileConvert(TaskContext taskContext) {
        return new DsV1FileConvert(taskContext);
    }

    public AbstractConvert<List<WorkflowNode>> getNodeListConvert(String taskTypeStr, TaskContext taskContext, Workflow workflow) {
        TaskType taskType = TaskType.valueOf((String)taskTypeStr);
        AbstractNodeConvert abstractNodeConvert = Optional.ofNullable(taskType).map(type -> {
            switch (taskType) {
                case SQL: {
                    return new SqlNodeConvert(taskContext, workflow);
                }
                case PYTHON: {
                    return new PyNodeConvert(taskContext, workflow);
                }
                case SPARK: {
                    return new SparkNodeConvert(taskContext, workflow);
                }
                case CONDITIONS: {
                    return new ConditionsNodeConvert(taskContext, workflow);
                }
                case SUB_PROCESS: {
                    return new SubProcessNodeConvert(taskContext, workflow);
                }
                case DEPENDENT: {
                    return new DependentNodeConvert(taskContext, workflow);
                }
                case SHELL: {
                    return new ShellNodeConvert(taskContext, workflow);
                }
                case MR: {
                    return new MrNodeConvert(taskContext, workflow);
                }
                case SQOOP: {
                    return new SqoopNodeConvert(taskContext, workflow);
                }
                case DATAX: {
                    return new DataxNodeConvert(taskContext, workflow);
                }
            }
            log.warn("user default convert {}", (Object)taskType.getDescp());
            return new DefaultNodeConvert(taskContext, workflow);
        }).get();
        return abstractNodeConvert;
    }

    public AbstractConvert<List<WorkflowNode>> getCustomNodeConvert(TaskContext taskContext, WorkflowNode workflowNode, Workflow workflow) {
        String originScript = workflowNode.getOriginScript();
        TaskNode taskDefinition = (TaskNode)BwmJsonUtil.parseObject((String)originScript, TaskNode.class);
        String taskType = taskDefinition.getType().toString();
        workflowNode.setNodeId(String.valueOf(taskDefinition.getId()));
        workflowNode.setNodeName(taskDefinition.getName());
        workflowNode.setNodeType(taskType);
        workflowNode.setPriority(Integer.valueOf(taskDefinition.getTaskInstancePriority().getCode()));
        workflowNode.setScript(taskDefinition.getParams());
        return this.getNodeListConvert(taskType, taskContext, workflow);
    }
}

