/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.utils.filewatch;

import com.alibaba.securitysdk.logging.utils.OsUtils;
import com.alibaba.securitysdk.logging.utils.filewatch.FileWatchEventListener;
import com.alibaba.securitysdk.logging.utils.filewatch.FileWatchException;
import com.alibaba.securitysdk.logging.utils.filewatch.WatchOnCreateFileWatchEventListener;
import com.sun.nio.file.ExtendedWatchEventModifier;
import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileWatcher {
    private static Logger logger = Logger.getLogger(FileWatcher.class.getName());
    private static final WatchEvent.Kind<?>[] WATCH_EVENT_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
    private final WatchService watchService;
    private final Path root;
    private boolean recursive;
    private ExecutorService executorService;
    private List<FileWatchEventListener> fileWatchingListeners;
    private volatile boolean isStarted = false;
    private SensitivityWatchEventModifier sensitivityWatchEventModifier;
    private final Map<WatchKey, Path> keys;
    private final List<FileWatchEventListener> defautlFileWatchingListeners;

    public FileWatcher(Path root) throws IOException {
        this(root, false, false);
    }

    public FileWatcher(Path root, boolean recursive) throws IOException {
        this(root, recursive, false);
    }

    public FileWatcher(Path root, boolean recursive, boolean watchWhenCreate) throws IOException {
        this.root = this.checkRoot(root);
        this.recursive = recursive;
        this.fileWatchingListeners = new CopyOnWriteArrayList<FileWatchEventListener>();
        this.defautlFileWatchingListeners = Collections.singletonList(new WatchOnCreateFileWatchEventListener(this));
        if (watchWhenCreate) {
            this.fileWatchingListeners.addAll(this.defautlFileWatchingListeners);
        }
        this.keys = new ConcurrentHashMap<WatchKey, Path>();
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        this.watchService = FileSystems.getDefault().newWatchService();
    }

    public void registerListener(FileWatchEventListener listener) {
        this.fileWatchingListeners.add(listener);
    }

    public void registerListeners(Collection<FileWatchEventListener> listeners) {
        this.fileWatchingListeners.addAll(listeners);
    }

    public List<FileWatchEventListener> listFileWatchingListeners() {
        return this.fileWatchingListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        if (!this.isStarted) {
            FileWatcher fileWatcher = this;
            synchronized (fileWatcher) {
                if (!this.isStarted) {
                    if (this.recursive) {
                        this.registerRecursive();
                    } else {
                        this.register(this.root, SensitivityWatchEventModifier.HIGH);
                    }
                    this.executorService.execute(new FileWatchTask());
                    this.isStarted = true;
                }
            }
        }
    }

    public void stop() throws IOException {
        if (this.isStarted) {
            this.watchService.close();
            this.executorService.shutdown();
        } else if (!this.executorService.isShutdown()) {
            throw new FileWatchException("The watcher has not yet started!");
        }
    }

    boolean isStarted() {
        return this.isStarted;
    }

    private Path checkRoot(Path root) {
        if (!root.toFile().exists() && root.toFile().isDirectory()) {
            throw new RuntimeException("folder " + root + " does not exist or is not a folder");
        }
        return root;
    }

    private void registerRecursive() throws IOException {
        if (OsUtils.IS_OS_WINDOWS) {
            this.root.register(this.watchService, WATCH_EVENT_KINDS, ExtendedWatchEventModifier.FILE_TREE, SensitivityWatchEventModifier.HIGH);
        } else {
            Files.walkFileTree(this.root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    FileWatcher.this.register(dir, SensitivityWatchEventModifier.HIGH);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    void register(Path dir, WatchEvent.Modifier ... modifiers) throws IOException {
        WatchKey key = dir.register(this.watchService, WATCH_EVENT_KINDS, modifiers);
        Path prev = this.keys.get(key);
        if (prev == null) {
            logger.log(Level.INFO, "register: {0}", new Object[]{dir});
        } else if (!dir.equals(prev)) {
            logger.log(Level.INFO, "update: {0} -> {1}", new Object[]{prev, dir});
        }
        this.keys.put(key, dir);
    }

    void processWatching() throws IOException, InterruptedException {
        WatchKey watchKey;
        while ((watchKey = this.watchService.take()) != null) {
            for (WatchEvent<?> event : watchKey.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                Path dir = this.keys.get(watchKey);
                if (dir == null) {
                    logger.info("WatchKey not recognized!!");
                    continue;
                }
                for (FileWatchEventListener listener : this.fileWatchingListeners) {
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        listener.onCreateEvent(watchKey, event);
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        listener.onModifyEvent(watchKey, event);
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    listener.onDeleteEvent(watchKey, event);
                }
            }
            if (watchKey.reset()) continue;
            watchKey.cancel();
            this.watchService.close();
            this.keys.remove(watchKey);
            if (!this.keys.isEmpty()) continue;
            break;
        }
    }

    class FileWatchTask
    implements Runnable {
        FileWatchTask() {
        }

        @Override
        public void run() {
            try {
                FileWatcher.this.processWatching();
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                throw new FileWatchException(e);
            }
        }
    }
}

