/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.logging.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IoUtils {
    private static Logger logger = Logger.getLogger(IoUtils.class.getSimpleName());

    private IoUtils() {
    }

    public static FileOutputStream createFileOuputStreamQuietly(String fileName, boolean append) {
        try {
            return IoUtils.createFileOuputStream(fileName, append);
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Error when create FileOutputStream for file [" + fileName + "]", e);
            }
            return null;
        }
    }

    public static FileOutputStream createFileOuputStream(String fileName, boolean append) throws IOException {
        FileOutputStream fileOutputStream;
        try {
            fileOutputStream = new FileOutputStream(fileName, append);
        }
        catch (FileNotFoundException ex) {
            String parentName = new File(fileName).getParent();
            if (parentName != null) {
                Files.createDirectories(Paths.get(parentName, new String[0]), new FileAttribute[0]);
                fileOutputStream = new FileOutputStream(fileName, append);
            }
            throw ex;
        }
        return fileOutputStream;
    }

    public static OutputStreamWriter createOutputStreamWriter(OutputStream os, String charsetName) {
        OutputStreamWriter writer;
        block3: {
            writer = null;
            try {
                writer = new OutputStreamWriter(os, charsetName);
            }
            catch (IOException e) {
                if (!(e instanceof InterruptedIOException)) break block3;
                Thread.currentThread().interrupt();
            }
        }
        if (writer == null) {
            writer = new OutputStreamWriter(os);
        }
        return writer;
    }

    public static void closeWriterQietly(OutputStreamWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                if (e instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                logger.log(Level.SEVERE, "Could not close " + writer, e);
            }
        }
    }
}

