/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.autoreload;

import com.aliyun.rapt.commons.autoreload.PolicyReloadedListener;
import com.aliyun.rapt.commons.autoreload.PolicyResourceReloadMonitor;
import com.aliyun.rapt.commons.autoreload.PolicyResourceReloadingException;
import com.aliyun.rapt.commons.autoreload.adaptor.DiamondPolicyReloadMonitor;
import com.aliyun.rapt.commons.autoreload.adaptor.FilePolicyReloadMonitor;
import com.aliyun.rapt.commons.autoreload.config.AutoReloadConfig;
import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.rapt.commons.utils.ClassUtils;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.NonNull;

public class PolicyResourceReloadMonitors
implements PolicyResourceReloadMonitor {
    private static final Logger logger = SecurityLogManager.getLogger((String)"reload");
    private static final String DIAMOND_CLASS = "com.taobao.diamond.client.Diamond";
    @NonNull
    private AutoReloadConfig config;
    @NonNull
    private PolicyReloadedListener listener;
    private PolicyResourceReloadMonitor policyResourceReloadMonitor;

    @Override
    public void start() throws PolicyResourceReloadingException {
        if (!this.config.isEnabled()) {
            return;
        }
        this.policyResourceReloadMonitor = this.createMonitor();
        if (this.policyResourceReloadMonitor != null) {
            this.policyResourceReloadMonitor.start();
        }
    }

    private PolicyResourceReloadMonitor createMonitor() {
        if (!this.config.isEnabled()) {
            return null;
        }
        if (this.config.getDiamond().isEnabled() && this.isDiamondPresent()) {
            return new DiamondPolicyReloadMonitor(this.listener);
        }
        Path watchedPolicyFilePath = Paths.get(this.config.getDynamicPolicyPath(), new String[0]);
        return new FilePolicyReloadMonitor(this.listener, watchedPolicyFilePath);
    }

    @Override
    public void destroy() throws PolicyResourceReloadingException {
        this.policyResourceReloadMonitor.destroy();
    }

    private boolean isDiamondPresent() {
        return ClassUtils.isPresent((String)DIAMOND_CLASS, (ClassLoader)this.getClass().getClassLoader());
    }

    public PolicyResourceReloadMonitors(@NonNull AutoReloadConfig config, @NonNull PolicyReloadedListener listener) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.config = config;
        this.listener = listener;
    }
}

