/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.api.ext;

import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import com.aliyun.securitysdk.rass.api.CheckResult;
import com.aliyun.securitysdk.rass.api.PermissionChecker;
import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.condition.Action;
import com.aliyun.securitysdk.rass.api.ext.BooleanCheckResult;
import com.aliyun.securitysdk.rass.api.ext.NativePermission;
import java.util.Collections;
import java.util.List;

public class NativePermissionChecker
implements PermissionChecker<NativePermission> {
    private static final Logger logger = SecurityLogManager.getLogger(NativePermissionChecker.class);
    private boolean enabled;
    private PermissionMode permissionMode;
    private List<Action> actionList;

    public NativePermissionChecker(boolean enabled, PermissionMode permissionMode, List<Action> actionList) {
        this.enabled = enabled;
        this.permissionMode = permissionMode;
        this.actionList = actionList;
    }

    @Override
    public String getName() {
        return null;
    }

    private boolean checkPermission(NativePermission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return true;
        }
        try {
            securityManager.checkPermission(permission.getNativePermission());
            return true;
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    @Override
    public CheckResult observe(NativePermission permission) {
        boolean result = this.checkPermission(permission);
        if (!result) {
            logger.info("Permission [{}] is not allowed, detail: {}", (Object)permission.getName(), permission.getResource());
        }
        return BooleanCheckResult.of(result);
    }

    @Override
    public CheckResult handle(NativePermission permission) {
        return BooleanCheckResult.of(this.checkPermission(permission));
    }

    @Override
    public List<Action> getDefaultActionList() {
        return Collections.emptyList();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public PermissionMode getPermissionMode() {
        return this.permissionMode;
    }

    @Override
    public List<Action> getActionList() {
        return this.actionList;
    }
}

