/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.securitysdk.rass.api.ext;

import com.aliyun.securitysdk.rass.api.Permission;
import com.aliyun.securitysdk.rass.api.PermissionChecker;
import com.aliyun.securitysdk.rass.api.PermissionMode;
import com.aliyun.securitysdk.rass.api.condition.Action;
import java.util.Arrays;
import java.util.List;

public abstract class ConfigurablePermissionChecker<T extends Permission>
implements PermissionChecker<T> {
    private final boolean enabled;
    private final String name;
    private final List<Action> actionList;
    private final PermissionMode permissionMode;
    private byte actionBit = 0;

    public ConfigurablePermissionChecker(String name) {
        this(true, name, PermissionMode.Operation, new Action[0]);
    }

    public ConfigurablePermissionChecker(boolean enabled, String name) {
        this(enabled, name, PermissionMode.Operation, new Action[0]);
    }

    public ConfigurablePermissionChecker(boolean enabled, String name, PermissionMode permissionMode, Action ... actions) {
        this.enabled = enabled;
        this.name = name;
        this.permissionMode = permissionMode;
        this.actionList = actions != null && actions.length > 0 ? Arrays.asList(actions) : this.getDefaultActionList();
        for (Action action : this.actionList) {
            this.actionBit = (byte)(this.actionBit | action.getCode());
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Action> getActionList() {
        return this.actionList;
    }

    @Override
    public PermissionMode getPermissionMode() {
        return this.permissionMode;
    }

    public byte getActionBit() {
        return this.actionBit;
    }
}

