/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers;

import com.alibaba.securitysdk.org.apache.xerces.impl.xs.SchemaGrammar;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.SchemaSymbols;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSAnnotationImpl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSParticleDecl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSWildcardDecl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers.XSDHandler;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.util.XInt;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.util.XSObjectListImpl;
import com.alibaba.securitysdk.org.apache.xerces.util.DOMUtil;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSObjectList;
import com.alibaba.securitysdk.org.w3c.dom.Element;
import com.alibaba.securitysdk.org.w3c.dom.Node;

class XSDWildcardTraverser
extends XSDAbstractTraverser {
    XSDWildcardTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSParticleDecl traverseAny(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, false, schemaDoc);
        XSWildcardDecl wildcard = this.traverseWildcardDecl(elmNode, attrValues, schemaDoc, grammar);
        XSParticleDecl particle = null;
        if (wildcard != null) {
            int min = ((XInt)attrValues[XSAttributeChecker.ATTIDX_MINOCCURS]).intValue();
            int max = ((XInt)attrValues[XSAttributeChecker.ATTIDX_MAXOCCURS]).intValue();
            if (max != 0) {
                particle = this.fSchemaHandler.fDeclPool != null ? this.fSchemaHandler.fDeclPool.getParticleDecl() : new XSParticleDecl();
                particle.fType = (short)2;
                particle.fValue = wildcard;
                particle.fMinOccurs = min;
                particle.fMaxOccurs = max;
                particle.fAnnotations = wildcard.fAnnotations;
            }
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return particle;
    }

    XSWildcardDecl traverseAnyAttribute(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, false, schemaDoc);
        XSWildcardDecl wildcard = this.traverseWildcardDecl(elmNode, attrValues, schemaDoc, grammar);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return wildcard;
    }

    XSWildcardDecl traverseWildcardDecl(Element elmNode, Object[] attrValues, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        XSObjectList annotations;
        String text;
        XSWildcardDecl wildcard = new XSWildcardDecl();
        XInt namespaceTypeAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_NAMESPACE];
        wildcard.fType = namespaceTypeAttr.shortValue();
        wildcard.fNamespaceList = (String[])attrValues[XSAttributeChecker.ATTIDX_NAMESPACE_LIST];
        XInt processContentsAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_PROCESSCONTENTS];
        wildcard.fProcessContents = processContentsAttr.shortValue();
        Element child = DOMUtil.getFirstChildElement((Node)elmNode);
        XSAnnotationImpl annotation = null;
        if (child != null) {
            if (DOMUtil.getLocalName((Node)child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                annotation = this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
                child = DOMUtil.getNextSiblingElement((Node)child);
            } else {
                text = DOMUtil.getSyntheticAnnotation((Node)elmNode);
                if (text != null) {
                    annotation = this.traverseSyntheticAnnotation(elmNode, text, attrValues, false, schemaDoc);
                }
            }
            if (child != null) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{"wildcard", "(annotation?)", DOMUtil.getLocalName((Node)child)}, elmNode);
            }
        } else {
            text = DOMUtil.getSyntheticAnnotation((Node)elmNode);
            if (text != null) {
                annotation = this.traverseSyntheticAnnotation(elmNode, text, attrValues, false, schemaDoc);
            }
        }
        if (annotation != null) {
            annotations = new XSObjectListImpl();
            ((XSObjectListImpl)annotations).add(annotation);
        } else {
            annotations = XSObjectListImpl.EMPTY_LIST;
        }
        wildcard.fAnnotations = annotations;
        return wildcard;
    }
}

