/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers;

import com.alibaba.securitysdk.org.apache.xerces.impl.xs.SchemaGrammar;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.SchemaSymbols;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSAnnotationImpl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSNotationDecl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers.XSDHandler;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.util.XSObjectListImpl;
import com.alibaba.securitysdk.org.apache.xerces.util.DOMUtil;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSObjectList;
import com.alibaba.securitysdk.org.w3c.dom.Element;
import com.alibaba.securitysdk.org.w3c.dom.Node;

class XSDNotationTraverser
extends XSDAbstractTraverser {
    XSDNotationTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSNotationDecl traverse(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        XSObjectList annotations;
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, true, schemaDoc);
        String nameAttr = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        String publicAttr = (String)attrValues[XSAttributeChecker.ATTIDX_PUBLIC];
        String systemAttr = (String)attrValues[XSAttributeChecker.ATTIDX_SYSTEM];
        if (nameAttr == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_NOTATION, SchemaSymbols.ATT_NAME}, elmNode);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return null;
        }
        if (systemAttr == null && publicAttr == null) {
            this.reportSchemaError("PublicSystemOnNotation", null, elmNode);
        }
        XSNotationDecl notation = new XSNotationDecl();
        notation.fName = nameAttr;
        notation.fTargetNamespace = schemaDoc.fTargetNamespace;
        notation.fPublicId = publicAttr;
        notation.fSystemId = systemAttr;
        Element content = DOMUtil.getFirstChildElement((Node)elmNode);
        XSAnnotationImpl annotation = null;
        if (content != null && DOMUtil.getLocalName((Node)content).equals(SchemaSymbols.ELT_ANNOTATION)) {
            annotation = this.traverseAnnotationDecl(content, attrValues, false, schemaDoc);
            content = DOMUtil.getNextSiblingElement((Node)content);
        } else {
            String text = DOMUtil.getSyntheticAnnotation((Node)elmNode);
            if (text != null) {
                annotation = this.traverseSyntheticAnnotation(elmNode, text, attrValues, false, schemaDoc);
            }
        }
        if (annotation != null) {
            annotations = new XSObjectListImpl();
            ((XSObjectListImpl)annotations).add(annotation);
        } else {
            annotations = XSObjectListImpl.EMPTY_LIST;
        }
        notation.fAnnotations = annotations;
        if (content != null) {
            Object[] args = new Object[]{SchemaSymbols.ELT_NOTATION, "(annotation?)", DOMUtil.getLocalName((Node)content)};
            this.reportSchemaError("s4s-elt-must-match.1", args, content);
        }
        grammar.addGlobalNotationDecl(notation);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return notation;
    }
}

