/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.org.apache.xerces.impl.xs.models;

import com.alibaba.securitysdk.org.apache.xerces.impl.dtd.models.CMNode;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSComplexTypeDecl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSDeclarationPool;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSElementDecl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSModelGroupImpl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSParticleDecl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.models.CMNodeFactory;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.models.XSAllCM;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.models.XSCMBinOp;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.models.XSCMLeaf;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.models.XSCMUniOp;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.models.XSCMValidator;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.models.XSDFACM;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.models.XSEmptyCM;

public class CMBuilder {
    private XSDeclarationPool fDeclPool = null;
    private static XSEmptyCM fEmptyCM = new XSEmptyCM();
    private int fLeafCount;
    private int fParticleCount;
    private CMNodeFactory fNodeFactory;

    public CMBuilder(CMNodeFactory nodeFactory) {
        this.fNodeFactory = nodeFactory;
    }

    public void setDeclPool(XSDeclarationPool declPool) {
        this.fDeclPool = declPool;
    }

    public XSCMValidator getContentModel(XSComplexTypeDecl typeDecl) {
        short contentType = typeDecl.getContentType();
        if (contentType == 1 || contentType == 0) {
            return null;
        }
        XSParticleDecl particle = (XSParticleDecl)typeDecl.getParticle();
        if (particle == null) {
            return fEmptyCM;
        }
        XSCMValidator cmValidator = null;
        cmValidator = particle.fType == 3 && ((XSModelGroupImpl)particle.fValue).fCompositor == 103 ? this.createAllCM(particle) : this.createDFACM(particle);
        this.fNodeFactory.resetNodeCount();
        if (cmValidator == null) {
            cmValidator = fEmptyCM;
        }
        return cmValidator;
    }

    XSCMValidator createAllCM(XSParticleDecl particle) {
        if (particle.fMaxOccurs == 0) {
            return null;
        }
        XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
        XSAllCM allContent = new XSAllCM(particle.fMinOccurs == 0, group.fParticleCount);
        for (int i = 0; i < group.fParticleCount; ++i) {
            allContent.addElement((XSElementDecl)group.fParticles[i].fValue, group.fParticles[i].fMinOccurs == 0);
        }
        return allContent;
    }

    XSCMValidator createDFACM(XSParticleDecl particle) {
        this.fLeafCount = 0;
        this.fParticleCount = 0;
        CMNode node = this.buildSyntaxTree(particle);
        if (node == null) {
            return null;
        }
        return new XSDFACM(node, this.fLeafCount);
    }

    private CMNode buildSyntaxTree(XSParticleDecl particle) {
        int maxOccurs = particle.fMaxOccurs;
        int minOccurs = particle.fMinOccurs;
        short type = particle.fType;
        CMNode nodeRet = null;
        if (type == 2 || type == 1) {
            nodeRet = this.fNodeFactory.getCMLeafNode(particle.fType, particle.fValue, this.fParticleCount++, this.fLeafCount++);
            nodeRet = this.expandContentModel(nodeRet, minOccurs, maxOccurs);
        } else if (type == 3) {
            XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
            CMNode temp = null;
            boolean twoChildren = false;
            for (int i = 0; i < group.fParticleCount; ++i) {
                temp = this.buildSyntaxTree(group.fParticles[i]);
                if (temp == null) continue;
                if (nodeRet == null) {
                    nodeRet = temp;
                    continue;
                }
                nodeRet = this.fNodeFactory.getCMBinOpNode(group.fCompositor, nodeRet, temp);
                twoChildren = true;
            }
            if (nodeRet != null) {
                if (group.fCompositor == 101 && !twoChildren && group.fParticleCount > 1) {
                    nodeRet = this.fNodeFactory.getCMUniOpNode(5, nodeRet);
                }
                nodeRet = this.expandContentModel(nodeRet, minOccurs, maxOccurs);
            }
        }
        return nodeRet;
    }

    private CMNode expandContentModel(CMNode node, int minOccurs, int maxOccurs) {
        CMNode nodeRet = null;
        if (minOccurs == 1 && maxOccurs == 1) {
            nodeRet = node;
        } else if (minOccurs == 0 && maxOccurs == 1) {
            nodeRet = this.fNodeFactory.getCMUniOpNode(5, node);
        } else if (minOccurs == 0 && maxOccurs == -1) {
            nodeRet = this.fNodeFactory.getCMUniOpNode(4, node);
        } else if (minOccurs == 1 && maxOccurs == -1) {
            nodeRet = this.fNodeFactory.getCMUniOpNode(6, node);
        } else if (maxOccurs == -1) {
            nodeRet = this.fNodeFactory.getCMUniOpNode(6, node);
            nodeRet = this.fNodeFactory.getCMBinOpNode(102, this.multiNodes(node, minOccurs - 1, true), nodeRet);
        } else {
            if (minOccurs > 0) {
                nodeRet = this.multiNodes(node, minOccurs, false);
            }
            if (maxOccurs > minOccurs) {
                node = this.fNodeFactory.getCMUniOpNode(5, node);
                nodeRet = nodeRet == null ? this.multiNodes(node, maxOccurs - minOccurs, false) : this.fNodeFactory.getCMBinOpNode(102, nodeRet, this.multiNodes(node, maxOccurs - minOccurs, true));
            }
        }
        return nodeRet;
    }

    private CMNode multiNodes(CMNode node, int num, boolean copyFirst) {
        if (num == 0) {
            return null;
        }
        if (num == 1) {
            return copyFirst ? this.copyNode(node) : node;
        }
        int num1 = num / 2;
        return this.fNodeFactory.getCMBinOpNode(102, this.multiNodes(node, num1, copyFirst), this.multiNodes(node, num - num1, true));
    }

    private CMNode copyNode(CMNode node) {
        int type = node.type();
        if (type == 101 || type == 102) {
            XSCMBinOp bin = (XSCMBinOp)node;
            node = this.fNodeFactory.getCMBinOpNode(type, this.copyNode(bin.getLeft()), this.copyNode(bin.getRight()));
        } else if (type == 4 || type == 6 || type == 5) {
            XSCMUniOp uni = (XSCMUniOp)node;
            node = this.fNodeFactory.getCMUniOpNode(type, this.copyNode(uni.getChild()));
        } else if (type == 1 || type == 2) {
            XSCMLeaf leaf = (XSCMLeaf)node;
            node = this.fNodeFactory.getCMLeafNode(leaf.type(), leaf.getLeaf(), leaf.getParticleId(), this.fLeafCount++);
        }
        return node;
    }
}

