/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.org.apache.xerces.impl.xs;

import com.alibaba.securitysdk.org.apache.xerces.impl.xs.SchemaGrammar;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.SchemaSymbols;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSAnnotationImpl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.XSElementDecl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.util.NSItemListImpl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.util.StringListImpl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.util.XSNamedMap4Types;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.util.XSNamedMapImpl;
import com.alibaba.securitysdk.org.apache.xerces.impl.xs.util.XSObjectListImpl;
import com.alibaba.securitysdk.org.apache.xerces.util.SymbolHash;
import com.alibaba.securitysdk.org.apache.xerces.util.XMLSymbols;
import com.alibaba.securitysdk.org.apache.xerces.xs.StringList;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSAttributeDeclaration;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSAttributeGroupDefinition;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSElementDeclaration;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSModel;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSModelGroupDefinition;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSNamedMap;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSNamespaceItemList;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSNotationDeclaration;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSObject;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSObjectList;
import com.alibaba.securitysdk.org.apache.xerces.xs.XSTypeDefinition;
import java.util.Vector;

public class XSModelImpl
implements XSModel {
    private static final short MAX_COMP_IDX = 16;
    private static final boolean[] GLOBAL_COMP = new boolean[]{false, true, true, true, false, true, true, false, false, false, false, true, false, false, false, true, true};
    private int fGrammarCount;
    private String[] fNamespaces;
    private SchemaGrammar[] fGrammarList;
    private SymbolHash fGrammarMap;
    private SymbolHash fSubGroupMap;
    private XSNamedMap[] fGlobalComponents;
    private XSNamedMap[][] fNSComponents;
    private XSObjectListImpl fAnnotations = null;
    private boolean fHasIDC = false;

    public XSModelImpl(SchemaGrammar[] grammars) {
        int i;
        int len = grammars.length;
        this.fNamespaces = new String[Math.max(len + 1, 5)];
        this.fGrammarList = new SchemaGrammar[Math.max(len + 1, 5)];
        boolean hasS4S = false;
        for (int i2 = 0; i2 < len; ++i2) {
            this.fNamespaces[i2] = grammars[i2].getTargetNamespace();
            this.fGrammarList[i2] = grammars[i2];
            if (this.fNamespaces[i2] != SchemaSymbols.URI_SCHEMAFORSCHEMA) continue;
            hasS4S = true;
        }
        if (!hasS4S) {
            this.fNamespaces[len] = SchemaSymbols.URI_SCHEMAFORSCHEMA;
            this.fGrammarList[len++] = SchemaGrammar.SG_SchemaNS;
        }
        for (i = 0; i < len; ++i) {
            int j;
            SchemaGrammar sg1 = this.fGrammarList[i];
            Vector gs = sg1.getImportedGrammars();
            int n = j = gs == null ? -1 : gs.size() - 1;
            while (j >= 0) {
                int k;
                SchemaGrammar sg2 = (SchemaGrammar)gs.elementAt(j);
                for (k = 0; k < len && sg2 != this.fGrammarList[k]; ++k) {
                }
                if (k == len) {
                    if (len == this.fGrammarList.length) {
                        String[] newSA = new String[len * 2];
                        System.arraycopy(this.fNamespaces, 0, newSA, 0, len);
                        this.fNamespaces = newSA;
                        SchemaGrammar[] newGA = new SchemaGrammar[len * 2];
                        System.arraycopy(this.fGrammarList, 0, newGA, 0, len);
                        this.fGrammarList = newGA;
                    }
                    this.fNamespaces[len] = sg2.getTargetNamespace();
                    this.fGrammarList[len] = sg2;
                    ++len;
                }
                --j;
            }
        }
        this.fGrammarMap = new SymbolHash(len * 2);
        for (i = 0; i < len; ++i) {
            this.fGrammarMap.put(XSModelImpl.null2EmptyString(this.fNamespaces[i]), this.fGrammarList[i]);
            if (!this.fGrammarList[i].hasIDConstraints()) continue;
            this.fHasIDC = true;
        }
        this.fGrammarCount = len;
        this.fGlobalComponents = new XSNamedMap[17];
        this.fNSComponents = new XSNamedMap[len][17];
        this.buildSubGroups();
    }

    private void buildSubGroups() {
        SubstitutionGroupHandler sgHandler = new SubstitutionGroupHandler(null);
        for (int i = 0; i < this.fGrammarCount; ++i) {
            sgHandler.addSubstitutionGroup(this.fGrammarList[i].getSubstitutionGroups());
        }
        XSNamedMap elements = this.getComponents((short)2);
        int len = elements.getLength();
        this.fSubGroupMap = new SymbolHash(len * 2);
        for (int i = 0; i < len; ++i) {
            XSElementDecl head;
            XSObject[] subGroup = sgHandler.getSubstitutionGroup(head = (XSElementDecl)elements.item(i));
            this.fSubGroupMap.put(head, subGroup.length > 0 ? new XSObjectListImpl(subGroup, subGroup.length) : XSObjectListImpl.EMPTY_LIST);
        }
    }

    @Override
    public StringList getNamespaces() {
        return new StringListImpl(this.fNamespaces, this.fGrammarCount);
    }

    @Override
    public XSNamespaceItemList getNamespaceItems() {
        return new NSItemListImpl(this.fGrammarList, this.fGrammarCount);
    }

    @Override
    public synchronized XSNamedMap getComponents(short objectType) {
        if (objectType <= 0 || objectType > 16 || !GLOBAL_COMP[objectType]) {
            return XSNamedMapImpl.EMPTY_MAP;
        }
        SymbolHash[] tables = new SymbolHash[this.fGrammarCount];
        if (this.fGlobalComponents[objectType] == null) {
            block8: for (int i = 0; i < this.fGrammarCount; ++i) {
                switch (objectType) {
                    case 3: 
                    case 15: 
                    case 16: {
                        tables[i] = this.fGrammarList[i].fGlobalTypeDecls;
                        continue block8;
                    }
                    case 1: {
                        tables[i] = this.fGrammarList[i].fGlobalAttrDecls;
                        continue block8;
                    }
                    case 2: {
                        tables[i] = this.fGrammarList[i].fGlobalElemDecls;
                        continue block8;
                    }
                    case 5: {
                        tables[i] = this.fGrammarList[i].fGlobalAttrGrpDecls;
                        continue block8;
                    }
                    case 6: {
                        tables[i] = this.fGrammarList[i].fGlobalGroupDecls;
                        continue block8;
                    }
                    case 11: {
                        tables[i] = this.fGrammarList[i].fGlobalNotationDecls;
                    }
                }
            }
            this.fGlobalComponents[objectType] = objectType == 15 || objectType == 16 ? new XSNamedMap4Types(this.fNamespaces, tables, this.fGrammarCount, objectType) : new XSNamedMapImpl(this.fNamespaces, tables, this.fGrammarCount);
        }
        return this.fGlobalComponents[objectType];
    }

    @Override
    public synchronized XSNamedMap getComponentsByNamespace(short objectType, String namespace) {
        int i;
        if (objectType <= 0 || objectType > 16 || !GLOBAL_COMP[objectType]) {
            return XSNamedMapImpl.EMPTY_MAP;
        }
        if (namespace != null) {
            for (i = 0; i < this.fGrammarCount && !namespace.equals(this.fNamespaces[i]); ++i) {
            }
        } else {
            while (i < this.fGrammarCount && this.fNamespaces[i] != null) {
                ++i;
            }
        }
        if (i == this.fGrammarCount) {
            return XSNamedMapImpl.EMPTY_MAP;
        }
        if (this.fNSComponents[i][objectType] == null) {
            SymbolHash table = null;
            switch (objectType) {
                case 3: 
                case 15: 
                case 16: {
                    table = this.fGrammarList[i].fGlobalTypeDecls;
                    break;
                }
                case 1: {
                    table = this.fGrammarList[i].fGlobalAttrDecls;
                    break;
                }
                case 2: {
                    table = this.fGrammarList[i].fGlobalElemDecls;
                    break;
                }
                case 5: {
                    table = this.fGrammarList[i].fGlobalAttrGrpDecls;
                    break;
                }
                case 6: {
                    table = this.fGrammarList[i].fGlobalGroupDecls;
                    break;
                }
                case 11: {
                    table = this.fGrammarList[i].fGlobalNotationDecls;
                }
            }
            this.fNSComponents[i][objectType] = objectType == 15 || objectType == 16 ? new XSNamedMap4Types(namespace, table, objectType) : new XSNamedMapImpl(namespace, table);
        }
        return this.fNSComponents[i][objectType];
    }

    @Override
    public XSTypeDefinition getTypeDefinition(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSTypeDefinition)sg.fGlobalTypeDecls.get(name);
    }

    @Override
    public XSAttributeDeclaration getAttributeDeclaration(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSAttributeDeclaration)sg.fGlobalAttrDecls.get(name);
    }

    @Override
    public XSElementDeclaration getElementDeclaration(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSElementDeclaration)sg.fGlobalElemDecls.get(name);
    }

    @Override
    public XSAttributeGroupDefinition getAttributeGroup(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSAttributeGroupDefinition)sg.fGlobalAttrGrpDecls.get(name);
    }

    @Override
    public XSModelGroupDefinition getModelGroupDefinition(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSModelGroupDefinition)sg.fGlobalGroupDecls.get(name);
    }

    @Override
    public XSNotationDeclaration getNotationDeclaration(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSNotationDeclaration)sg.fGlobalNotationDecls.get(name);
    }

    @Override
    public synchronized XSObjectList getAnnotations() {
        if (this.fAnnotations != null) {
            return this.fAnnotations;
        }
        int totalAnnotations = 0;
        for (int i = 0; i < this.fGrammarCount; ++i) {
            totalAnnotations += this.fGrammarList[i].fNumAnnotations;
        }
        XSObject[] annotations = new XSAnnotationImpl[totalAnnotations];
        int currPos = 0;
        for (int i = 0; i < this.fGrammarCount; ++i) {
            SchemaGrammar currGrammar = this.fGrammarList[i];
            if (currGrammar.fNumAnnotations <= 0) continue;
            System.arraycopy(currGrammar.fAnnotations, 0, annotations, currPos, currGrammar.fNumAnnotations);
            currPos += currGrammar.fNumAnnotations;
        }
        this.fAnnotations = new XSObjectListImpl(annotations, annotations.length);
        return this.fAnnotations;
    }

    private static final String null2EmptyString(String str) {
        return str == null ? XMLSymbols.EMPTY_STRING : str;
    }

    public boolean hasIDConstraints() {
        return this.fHasIDC;
    }

    @Override
    public XSObjectList getSubstitutionGroup(XSElementDeclaration head) {
        return (XSObjectList)this.fSubGroupMap.get(head);
    }
}

