/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.org.apache.xerces.dom;

import com.alibaba.securitysdk.org.apache.xerces.dom.AttrImpl;
import com.alibaba.securitysdk.org.apache.xerces.dom.AttrNSImpl;
import com.alibaba.securitysdk.org.apache.xerces.dom.AttributeMap;
import com.alibaba.securitysdk.org.apache.xerces.dom.ChildNode;
import com.alibaba.securitysdk.org.apache.xerces.dom.CoreDocumentImpl;
import com.alibaba.securitysdk.org.apache.xerces.dom.DOMMessageFormatter;
import com.alibaba.securitysdk.org.apache.xerces.dom.DeepNodeListImpl;
import com.alibaba.securitysdk.org.apache.xerces.dom.DocumentTypeImpl;
import com.alibaba.securitysdk.org.apache.xerces.dom.ElementDefinitionImpl;
import com.alibaba.securitysdk.org.apache.xerces.dom.NamedNodeMapImpl;
import com.alibaba.securitysdk.org.apache.xerces.dom.NodeImpl;
import com.alibaba.securitysdk.org.apache.xerces.dom.ParentNode;
import com.alibaba.securitysdk.org.apache.xerces.util.URI;
import com.alibaba.securitysdk.org.w3c.dom.Attr;
import com.alibaba.securitysdk.org.w3c.dom.DOMException;
import com.alibaba.securitysdk.org.w3c.dom.Element;
import com.alibaba.securitysdk.org.w3c.dom.NamedNodeMap;
import com.alibaba.securitysdk.org.w3c.dom.Node;
import com.alibaba.securitysdk.org.w3c.dom.NodeList;
import com.alibaba.securitysdk.org.w3c.dom.Text;
import com.alibaba.securitysdk.org.w3c.dom.TypeInfo;

public class ElementImpl
extends ParentNode
implements Element,
TypeInfo {
    static final long serialVersionUID = 3717253516652722278L;
    protected String name;
    protected AttributeMap attributes;

    public ElementImpl(CoreDocumentImpl ownerDoc, String name) {
        super(ownerDoc);
        this.name = name;
        this.needsSyncData(true);
    }

    protected ElementImpl() {
    }

    void rename(String name) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.name = name;
        this.reconcileDefaultAttributes();
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    @Override
    public NamedNodeMap getAttributes() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return this.attributes;
    }

    @Override
    public Node cloneNode(boolean deep) {
        ElementImpl newnode = (ElementImpl)super.cloneNode(deep);
        if (this.attributes != null) {
            newnode.attributes = (AttributeMap)this.attributes.cloneMap(newnode);
        }
        return newnode;
    }

    @Override
    public String getBaseURI() {
        String baseURI;
        String uri;
        Attr attrNode;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes != null && (attrNode = (Attr)this.attributes.getNamedItem("xml:base")) != null && (uri = attrNode.getNodeValue()).length() != 0) {
            try {
                uri = new URI(uri).toString();
            }
            catch (URI.MalformedURIException e) {
                String parentBaseURI;
                String string = parentBaseURI = this.ownerNode != null ? this.ownerNode.getBaseURI() : null;
                if (parentBaseURI != null) {
                    try {
                        uri = new URI(new URI(parentBaseURI), uri).toString();
                    }
                    catch (URI.MalformedURIException ex) {
                        return null;
                    }
                    return uri;
                }
                return null;
            }
            return uri;
        }
        String string = baseURI = this.ownerNode != null ? this.ownerNode.getBaseURI() : null;
        if (baseURI != null) {
            try {
                return new URI(baseURI).toString();
            }
            catch (URI.MalformedURIException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected void setOwnerDocument(CoreDocumentImpl doc) {
        super.setOwnerDocument(doc);
        if (this.attributes != null) {
            this.attributes.setOwnerDocument(doc);
        }
    }

    public String getAttribute(String name) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItem(name);
        return attr == null ? "" : attr.getValue();
    }

    public Attr getAttributeNode(String name) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItem(name);
    }

    public NodeList getElementsByTagName(String tagname) {
        return new DeepNodeListImpl(this, tagname);
    }

    public String getTagName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    @Override
    public void normalize() {
        if (this.isNormalized()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ChildNode kid = this.firstChild;
        while (kid != null) {
            ChildNode next = kid.nextSibling;
            if (kid.getNodeType() == 3) {
                if (next != null && next.getNodeType() == 3) {
                    ((Text)kid).appendData(next.getNodeValue());
                    this.removeChild(next);
                    next = kid;
                } else if (kid.getNodeValue() == null || kid.getNodeValue().length() == 0) {
                    this.removeChild(kid);
                }
            } else if (kid.getNodeType() == 1) {
                kid.normalize();
            }
            kid = next;
        }
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.getLength(); ++i) {
                Node attr = this.attributes.item(i);
                attr.normalize();
            }
        }
        this.isNormalized(true);
    }

    public void removeAttribute(String name) {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return;
        }
        this.attributes.safeRemoveNamedItem(name);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        return (Attr)this.attributes.removeItem((Node)oldAttr, true);
    }

    public void setAttribute(String name, String value) {
        Attr newAttr;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((newAttr = this.getAttributeNode(name)) == null) {
            newAttr = this.getOwnerDocument().createAttribute(name);
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            newAttr.setNodeValue(value);
            this.attributes.setNamedItem((Node)newAttr);
        } else {
            newAttr.setNodeValue(value);
        }
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, msg);
            }
            if (newAttr.getOwnerDocument() != this.ownerDocument) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, msg);
            }
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return (Attr)this.attributes.setNamedItem((Node)newAttr);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItemNS(namespaceURI, localName);
        return attr == null ? "" : attr.getValue();
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        String localName;
        String prefix;
        int index;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((index = qualifiedName.indexOf(58)) < 0) {
            prefix = null;
            localName = qualifiedName;
        } else {
            prefix = qualifiedName.substring(0, index);
            localName = qualifiedName.substring(index + 1);
        }
        Attr newAttr = this.getAttributeNodeNS(namespaceURI, localName);
        if (newAttr == null) {
            newAttr = this.getOwnerDocument().createAttributeNS(namespaceURI, qualifiedName);
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            newAttr.setNodeValue(value);
            this.attributes.setNamedItemNS((Node)newAttr);
        } else {
            if (newAttr instanceof AttrNSImpl) {
                ((AttrNSImpl)newAttr).name = prefix != null ? prefix + ":" + localName : localName;
            } else {
                newAttr = new AttrNSImpl((CoreDocumentImpl)this.getOwnerDocument(), namespaceURI, qualifiedName, localName);
                this.attributes.setNamedItemNS((Node)newAttr);
            }
            newAttr.setNodeValue(value);
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return;
        }
        this.attributes.safeRemoveNamedItemNS(namespaceURI, localName);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItemNS(namespaceURI, localName);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, msg);
            }
            if (newAttr.getOwnerDocument() != this.ownerDocument) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, msg);
            }
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return (Attr)this.attributes.setNamedItemNS((Node)newAttr);
    }

    protected int setXercesAttributeNode(Attr attr) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return this.attributes.addItem((Node)attr);
    }

    protected int getXercesAttribute(String namespaceURI, String localName) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return -1;
        }
        return this.attributes.getNamedItemIndex(namespaceURI, localName);
    }

    @Override
    public boolean hasAttributes() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.attributes != null && this.attributes.getLength() != 0;
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new DeepNodeListImpl(this, namespaceURI, localName);
    }

    @Override
    public boolean isEqualNode(Node arg) {
        if (!super.isEqualNode(arg)) {
            return false;
        }
        boolean hasAttrs = this.hasAttributes();
        if (hasAttrs != ((Element)arg).hasAttributes()) {
            return false;
        }
        if (hasAttrs) {
            NamedNodeMap map1 = this.getAttributes();
            NamedNodeMap map2 = ((Element)arg).getAttributes();
            int len = map1.getLength();
            if (len != map2.getLength()) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                Node n2;
                Node n1 = map1.item(i);
                if (!(n1.getLocalName() == null ? (n2 = map2.getNamedItem(n1.getNodeName())) == null || !((NodeImpl)n1).isEqualNode(n2) : (n2 = map2.getNamedItemNS(n1.getNamespaceURI(), n1.getLocalName())) == null || !((NodeImpl)n1).isEqualNode(n2))) continue;
                return false;
            }
        }
        return true;
    }

    public void setIdAttributeNode(Attr at, boolean makeId) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, msg);
            }
            if (at.getOwnerElement() != this) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, msg);
            }
        }
        ((AttrImpl)at).isIdAttribute(makeId);
        if (!makeId) {
            this.ownerDocument.removeIdentifier(at.getValue());
        } else {
            this.ownerDocument.putIdentifier(at.getValue(), this);
        }
    }

    public void setIdAttribute(String name, boolean makeId) {
        Attr at;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((at = this.getAttributeNode(name)) == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, msg);
            }
            if (at.getOwnerElement() != this) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, msg);
            }
        }
        ((AttrImpl)at).isIdAttribute(makeId);
        if (!makeId) {
            this.ownerDocument.removeIdentifier(at.getValue());
        } else {
            this.ownerDocument.putIdentifier(at.getValue(), this);
        }
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean makeId) {
        Attr at;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((at = this.getAttributeNodeNS(namespaceURI, localName)) == null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, msg);
            }
            if (at.getOwnerElement() != this) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, msg);
            }
        }
        ((AttrImpl)at).isIdAttribute(makeId);
        if (!makeId) {
            this.ownerDocument.removeIdentifier(at.getValue());
        } else {
            this.ownerDocument.putIdentifier(at.getValue(), this);
        }
    }

    public String getTypeName() {
        return null;
    }

    public String getTypeNamespace() {
        return null;
    }

    public boolean isDerivedFrom(String typeNamespaceArg, String typeNameArg, int derivationMethod) {
        return false;
    }

    public TypeInfo getSchemaTypeInfo() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this;
    }

    @Override
    public void setReadOnly(boolean readOnly, boolean deep) {
        super.setReadOnly(readOnly, deep);
        if (this.attributes != null) {
            this.attributes.setReadOnly(readOnly, true);
        }
    }

    @Override
    protected void synchronizeData() {
        this.needsSyncData(false);
        boolean orig = this.ownerDocument.getMutationEvents();
        this.ownerDocument.setMutationEvents(false);
        this.setupDefaultAttributes();
        this.ownerDocument.setMutationEvents(orig);
    }

    void moveSpecifiedAttributes(ElementImpl el) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (el.hasAttributes()) {
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            this.attributes.moveSpecifiedAttributes(el.attributes);
        }
    }

    protected void setupDefaultAttributes() {
        NamedNodeMapImpl defaults = this.getDefaultAttributes();
        if (defaults != null) {
            this.attributes = new AttributeMap(this, defaults);
        }
    }

    protected void reconcileDefaultAttributes() {
        if (this.attributes != null) {
            NamedNodeMapImpl defaults = this.getDefaultAttributes();
            this.attributes.reconcileDefaults(defaults);
        }
    }

    protected NamedNodeMapImpl getDefaultAttributes() {
        DocumentTypeImpl doctype = (DocumentTypeImpl)this.ownerDocument.getDoctype();
        if (doctype == null) {
            return null;
        }
        ElementDefinitionImpl eldef = (ElementDefinitionImpl)doctype.getElements().getNamedItem(this.getNodeName());
        if (eldef == null) {
            return null;
        }
        return (NamedNodeMapImpl)eldef.getAttributes();
    }
}

