/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.css;

import com.alibaba.security.css.CSSReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class CSSStreamReader
extends CSSReader {
    private Reader rr;
    private char[] buffer;
    private int bufferpos = 0;
    private int bufferNum = 32;
    private int nextChar = -1;
    private int line = 1;
    private int column;

    public CSSStreamReader(InputStream in) throws UnsupportedEncodingException {
        this(in, null);
    }

    public CSSStreamReader(InputStream in, String encode) throws UnsupportedEncodingException {
        if (encode == null) {
            encode = "ISO8859_1";
        }
        this.rr = new InputStreamReader(in, encode);
        this.buffer = new char[this.bufferNum];
    }

    @Override
    public void pushBack(char[] cbuf, int off, int len) {
        int k;
        if (this.bufferpos + len > this.buffer.length) {
            int ln = this.buffer.length * 2 + 1;
            while (ln < this.bufferpos + len) {
                ln = ln * 2 + 1;
            }
            char[] tp = new char[ln];
            for (int i = 0; i < this.buffer.length; ++i) {
                tp[i] = this.buffer[i];
            }
            this.buffer = tp;
        }
        int i = this.bufferpos;
        int j = len - 1;
        int n = k = off + j > cbuf.length - 1 ? cbuf.length - 1 : off + j;
        while (j >= 0) {
            this.buffer[i] = cbuf[k];
            ++i;
            --j;
            --k;
        }
    }

    public CSSStreamReader(Reader reader) {
        this.rr = reader;
        this.buffer = new char[this.bufferNum];
    }

    public void setPushbackNum(int bufferNum) {
        this.bufferNum = bufferNum;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int read() throws IOException {
        if (this.bufferpos != 0) {
            return this.buffer[--this.bufferpos];
        }
        int result = this.nextChar;
        if (result != -1) {
            this.nextChar = -1;
            if (result == 13) {
                this.column = 0;
                ++this.line;
            } else {
                ++this.column;
            }
            return result;
        }
        result = this.rr.read();
        switch (result) {
            case 13: {
                this.column = 0;
                ++this.line;
                int c = this.rr.read();
                if (c == 10) {
                    return 10;
                }
                this.nextChar = c;
                return 10;
            }
            case 10: {
                this.column = 0;
                ++this.line;
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.rr.close();
    }
}

