/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.assistant.utils;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DataWorksPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.service.impl.DataWorksDwmaPackageFileService;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.workflow.migration.assistant.utils.DwAssistantPackageTransform;
import com.aliyun.migration.workflow.migration.common.file.UseMxFileUtil;
import com.aliyun.migration.workflow.migration.common.utils.BwmConfiguration;
import com.aliyun.migrationx.common.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwAssisantPackageFileService
extends DataWorksDwmaPackageFileService {
    private static final Logger log = LoggerFactory.getLogger(DwAssisantPackageFileService.class);

    public void DwAssisantPackageFileService() {
    }

    public void savePackageZip(WorkflowProjectPackage workflowProjectPackage, String filePath, BwmConfiguration taskContextConf) throws Exception {
        DwAssistantPackageTransform transformer = new DwAssistantPackageTransform();
        DataWorksPackage dataWorksPackage = transformer.translate(workflowProjectPackage, taskContextConf);
        if (dataWorksPackage == null) {
            log.info("\u8fc1\u79fb\u52a9\u624b\u5bfc\u5165\u5305\u751f\u6210\u5931\u8d25");
            return;
        }
        File file = new File(filePath);
        UseMxFileUtil.useDataWorksDwmaPackageFileService((DataWorksPackage)dataWorksPackage, (File)file);
        this.addFileIntoPackage(file, workflowProjectPackage);
        log.info("\u5bfc\u51fa\u5305\u5b8c\u6210");
    }

    public void addFileIntoPackage(File file, WorkflowProjectPackage workflowProjectPackage) throws IOException {
        File packageDir = ZipUtils.decompress((File)file);
        String filePath = packageDir.getAbsolutePath() + "/src/workflows";
        this.copyFile(workflowProjectPackage, filePath);
        ZipUtils.zipDir((File)packageDir, (File)file);
    }

    public void copyFile(WorkflowProjectPackage workflowProjectPackage, String filePath) throws IOException {
        for (Workflow workflow : workflowProjectPackage.getWorkflowList()) {
            if (CollectionUtils.isEmpty((Collection)workflow.getFiles())) continue;
            for (WorkflowFileResource file : workflow.getFiles()) {
                String source = file.getPath();
                String dest = filePath + "/BUSINESS_" + workflow.getWorkflowName() + "/resources/" + file.getName();
                try {
                    FileUtils.forceMkdir((File)new File(dest).getParentFile());
                    FileUtils.copyFile((File)new File(source), (File)new File(dest));
                }
                catch (IOException e) {
                    log.error("copy resource file error", (Throwable)e);
                }
            }
        }
    }
}

