/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.client.command;

import com.aliyun.dataworks.client.command.AppType;
import com.aliyun.dataworks.client.command.CommandApp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandAppFactory {
    private static final Logger log = LoggerFactory.getLogger(CommandAppFactory.class);
    private static final Map<AppType, Map<String, String>> commandApps = new HashMap<AppType, Map<String, String>>();

    public static void register(AppType appType, String appName, String readerAppClz) {
        Map apps = commandApps.computeIfAbsent(appType, type -> new HashMap());
        if (apps.containsKey(appName)) {
            return;
        }
        apps.put(appName, readerAppClz);
    }

    public static <T extends CommandApp> T create(AppType appType, String appName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (!commandApps.containsKey((Object)appType)) {
            throw new RuntimeException("unregistered app type: " + (Object)((Object)appType));
        }
        Map<String, String> apps = commandApps.get((Object)appType);
        if (!apps.containsKey(appName)) {
            log.error("appName: {} not found in apps: {}", (Object)appName, apps);
            throw new RuntimeException("unregistered app name: " + appName);
        }
        String clz = apps.get(appName);
        Class<?> clazz = Class.forName(clz);
        return (T)((CommandApp)clazz.newInstance());
    }

    public static Map<AppType, List<String>> getApps() {
        return MapUtils.emptyIfNull(commandApps).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, ent -> new ArrayList(((Map)ent.getValue()).keySet())));
    }
}

