/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.org.apache.xml.resolver.readers;

import com.alibaba.securitysdk.javax.xml.parsers.DocumentBuilder;
import com.alibaba.securitysdk.javax.xml.parsers.DocumentBuilderFactory;
import com.alibaba.securitysdk.javax.xml.parsers.ParserConfigurationException;
import com.alibaba.securitysdk.org.apache.xml.resolver.Catalog;
import com.alibaba.securitysdk.org.apache.xml.resolver.CatalogException;
import com.alibaba.securitysdk.org.apache.xml.resolver.helpers.Namespaces;
import com.alibaba.securitysdk.org.apache.xml.resolver.readers.CatalogReader;
import com.alibaba.securitysdk.org.apache.xml.resolver.readers.DOMCatalogParser;
import com.alibaba.securitysdk.org.w3c.dom.Document;
import com.alibaba.securitysdk.org.w3c.dom.Element;
import com.alibaba.securitysdk.org.w3c.dom.Node;
import com.alibaba.securitysdk.org.xml.sax.SAXException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;

public class DOMCatalogReader
implements CatalogReader {
    protected Hashtable namespaceMap = new Hashtable();

    public void setCatalogParser(String namespaceURI, String rootElement, String parserClass) {
        if (namespaceURI == null) {
            this.namespaceMap.put(rootElement, parserClass);
        } else {
            this.namespaceMap.put("{" + namespaceURI + "}" + rootElement, parserClass);
        }
    }

    public String getCatalogParser(String namespaceURI, String rootElement) {
        if (namespaceURI == null) {
            return (String)this.namespaceMap.get(rootElement);
        }
        return (String)this.namespaceMap.get("{" + namespaceURI + "}" + rootElement);
    }

    @Override
    public void readCatalog(Catalog catalog, InputStream is) throws IOException, CatalogException {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new CatalogException(6);
        }
        Document doc = null;
        try {
            doc = builder.parse(is);
        }
        catch (SAXException se) {
            throw new CatalogException(5);
        }
        Element root = doc.getDocumentElement();
        String namespaceURI = Namespaces.getNamespaceURI(root);
        String localName = Namespaces.getLocalName(root);
        String domParserClass = this.getCatalogParser(namespaceURI, localName);
        if (domParserClass == null) {
            if (namespaceURI == null) {
                catalog.getCatalogManager().debug.message(1, "No Catalog parser for " + localName);
            } else {
                catalog.getCatalogManager().debug.message(1, "No Catalog parser for {" + namespaceURI + "}" + localName);
            }
            return;
        }
        DOMCatalogParser domParser = null;
        try {
            int lastDot;
            SecurityManager security = System.getSecurityManager();
            if (security != null && (lastDot = domParserClass.lastIndexOf(46)) != -1) {
                String packageName = domParserClass.substring(0, lastDot);
                security.checkPackageAccess(packageName);
            }
            domParser = (DOMCatalogParser)Class.forName(domParserClass).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            catalog.getCatalogManager().debug.message(1, "Cannot load XML Catalog Parser class", domParserClass);
            throw new CatalogException(6);
        }
        catch (InstantiationException ie) {
            catalog.getCatalogManager().debug.message(1, "Cannot instantiate XML Catalog Parser class", domParserClass);
            throw new CatalogException(6);
        }
        catch (IllegalAccessException iae) {
            catalog.getCatalogManager().debug.message(1, "Cannot access XML Catalog Parser class", domParserClass);
            throw new CatalogException(6);
        }
        catch (ClassCastException cce) {
            catalog.getCatalogManager().debug.message(1, "Cannot cast XML Catalog Parser class", domParserClass);
            throw new CatalogException(6);
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            domParser.parseCatalogEntry(catalog, node);
        }
    }

    @Override
    public void readCatalog(Catalog catalog, String fileUrl) throws MalformedURLException, IOException, CatalogException {
        URL url = new URL(fileUrl);
        URLConnection urlCon = url.openConnection();
        this.readCatalog(catalog, urlCon.getInputStream());
    }
}

