/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext.impl;

import com.alibaba.security.codec.HtmlFastEntities;
import com.alibaba.security.xss.richtext.Policy;
import com.alibaba.security.xss.richtext.handler.TagProcessHandler;
import com.alibaba.security.xss.richtext.model.Action;
import com.alibaba.security.xss.richtext.model.Attribute;
import com.alibaba.security.xss.richtext.model.Tag;
import com.alibaba.security.xss.richtext.tools.SafeUrlUtils;
import com.alibaba.securitysdk.cyberneko.html.HTMLElements;
import com.alibaba.securitysdk.cyberneko.html.filters.DefaultFilter;
import com.alibaba.securitysdk.org.apache.xerces.xni.Augmentations;
import com.alibaba.securitysdk.org.apache.xerces.xni.NamespaceContext;
import com.alibaba.securitysdk.org.apache.xerces.xni.QName;
import com.alibaba.securitysdk.org.apache.xerces.xni.XMLAttributes;
import com.alibaba.securitysdk.org.apache.xerces.xni.XMLLocator;
import com.alibaba.securitysdk.org.apache.xerces.xni.XMLResourceIdentifier;
import com.alibaba.securitysdk.org.apache.xerces.xni.XMLString;
import com.alibaba.securitysdk.org.apache.xerces.xni.XNIException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class XssFilterDocumentHandler
extends DefaultFilter {
    private static String OFFSITEURL = "offsiteURL";
    private static String exp = "^(http[s]{0,1}:){0,1}//([a-z0-9\\-_]+\\.)*(huanqiu|globaltimes|kitco|export\\-entreprises)\\.(com|net|cn|com\\.cn)(/.*)?$";
    private static Pattern p = Pattern.compile(exp);
    private static final String[] NO_REPLACE = new String[]{"#", "."};
    protected int removalStack = 0;
    protected StringBuilder fwriterBuffer;
    protected boolean fSeenRootElement;
    protected boolean fNormalize;
    protected boolean fPrintChars;
    protected Map<String, Tag> tagRules;
    private Policy fPolicy;
    private InnerStack<TagProcessHandler> stack = new InnerStack();

    public XssFilterDocumentHandler(StringBuilder writerBuffer, Policy policy) {
        this.fwriterBuffer = writerBuffer;
        this.fPolicy = policy;
        this.tagRules = policy.getTagRules();
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext nscontext, Augmentations augs) {
        this.fSeenRootElement = false;
        this.fNormalize = true;
        this.fPrintChars = true;
        super.startDocument(locator, encoding, nscontext, augs);
    }

    public void startDocument(XMLLocator locator, String encoding, Augmentations augs) throws XNIException {
        this.startDocument(locator, encoding, null, augs);
    }

    public void startPrefixMapping(String prefix, String uri, Augmentations augs) throws XNIException {
        if (this.removalStack == 0) {
            super.startPrefixMapping(prefix, uri, augs);
        }
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        Tag tag = this.tagRules.get(this.fPolicy.toElemsCase(element.rawname));
        if (tag != null && tag.action == Action.HANDLER) {
            TagProcessHandler handler = this.getStartTagProcessHandler(tag.getActionHandler());
            if (handler == null) {
                throw new XNIException("handler null.");
            }
            handler.startElement(this.fwriterBuffer, element, attributes, augs, this.fPolicy);
            return;
        }
        if (this.handleOpenTag(element, attributes) && this.removalStack == 0) {
            this.fSeenRootElement = true;
            this.fNormalize = !HTMLElements.getElement((String)element.rawname).isSpecial();
            this.printStartElement(element, attributes);
            super.startElement(element, attributes, augs);
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        Tag tag = this.tagRules.get(this.fPolicy.toElemsCase(element.rawname));
        if (tag != null && tag.action == Action.HANDLER) {
            TagProcessHandler handler = this.getEndTagProcessHandler();
            if (handler == null) {
                throw new XNIException("handler null.");
            }
            handler.endElement(this.fwriterBuffer, element, augs);
            return;
        }
        if (this.handleCloseTag(element) && this.removalStack == 0) {
            this.fNormalize = true;
            this.printEndElement(element);
            super.endElement(element, augs);
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        Tag tag = this.tagRules.get(this.fPolicy.toElemsCase(element.rawname));
        if (tag != null && tag.action == Action.HANDLER) {
            tag.getActionHandler().emptyElement(this.fwriterBuffer, element, attributes, augs, this.fPolicy);
            return;
        }
        if (this.removalStack == 0 && this.handleEmptyTag(element, attributes)) {
            this.fSeenRootElement = true;
            this.printEmptyElement(element, attributes);
            super.emptyElement(element, attributes, augs);
        }
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (this.removalStack == 0 && !this.fPolicy.isRemoveComment()) {
            if (this.fSeenRootElement) {
                this.fwriterBuffer.append("\r\n");
            }
            this.fwriterBuffer.append("<!--");
            this.printCharacters(text, false);
            this.fwriterBuffer.append("-->");
            if (!this.fSeenRootElement) {
                this.fwriterBuffer.append("\r\n");
            }
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        if (this.removalStack == 0) {
            super.processingInstruction(target, data, augs);
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        TagProcessHandler handler = this.getProcessHandler();
        if (handler != null) {
            handler.characters(this.fwriterBuffer, text, augs);
            return;
        }
        if (this.removalStack == 0) {
            if (this.fPrintChars) {
                this.printCharacters(text, this.fNormalize);
            }
            super.characters(text, augs);
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (this.removalStack == 0) {
            super.ignorableWhitespace(text, augs);
        }
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier id, String encoding, Augmentations augs) throws XNIException {
        this.fPrintChars = false;
        if (this.removalStack == 0 && name.startsWith("#")) {
            try {
                boolean hex = name.startsWith("#x");
                int offset = hex ? 2 : 1;
                int base = hex ? 16 : 10;
                int value = Integer.parseInt(name.substring(offset), base);
                char[] entity = HtmlFastEntities.HTML40.getEntity((char)value);
                if (entity != null) {
                    name = new String(entity);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.fwriterBuffer.append(name);
        super.startGeneralEntity(name, id, encoding, augs);
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        if (this.removalStack == 0) {
            super.textDecl(version, encoding, augs);
        }
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        this.fPrintChars = true;
        if (this.removalStack == 0) {
            super.endGeneralEntity(name, augs);
        }
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        if (this.removalStack == 0) {
            super.startCDATA(augs);
        }
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        if (this.removalStack == 0) {
            super.endCDATA(augs);
        }
    }

    public void endPrefixMapping(String prefix, Augmentations augs) throws XNIException {
        if (this.removalStack == 0) {
            super.endPrefixMapping(prefix, augs);
        }
    }

    protected boolean handleOpenTag(QName element, XMLAttributes attributes) {
        Tag tag = this.tagRules.get(this.fPolicy.toElemsCase(element.rawname));
        if (tag != null) {
            Action action = tag.getAction();
            if (action == Action.ACCEPT || action == Action.CSSHANDLER) {
                return true;
            }
            if (tag.getAction() == Action.REMOVE) {
                ++this.removalStack;
            }
        } else {
            attributes.removeAllAttributes();
        }
        return false;
    }

    private boolean handleCloseTag(QName element) {
        Tag tag = this.tagRules.get(this.fPolicy.toElemsCase(element.rawname));
        boolean accept = false;
        if (tag != null) {
            Action action = tag.getAction();
            if (action == Action.ACCEPT || action == Action.CSSHANDLER) {
                accept = true;
            } else if (action == Action.REMOVE) {
                --this.removalStack;
            }
        }
        return accept;
    }

    protected boolean handleEmptyTag(QName element, XMLAttributes attributes) {
        Tag tag = this.tagRules.get(this.fPolicy.toElemsCase(element.rawname));
        if (tag != null) {
            Action action = tag.getAction();
            if (action == Action.ACCEPT || action == Action.CSSHANDLER) {
                return true;
            }
        } else {
            attributes.removeAllAttributes();
        }
        return false;
    }

    protected void printCharacters(XMLString text, boolean normalize) {
        if (normalize) {
            for (int i = 0; i < text.length; ++i) {
                char c = text.ch[text.offset + i];
                if (c == '\r' && i != text.length - 1 && text.ch[text.offset + i + 1] == '\n') {
                    this.fwriterBuffer.append("\r\n");
                    ++i;
                    continue;
                }
                if (c == ' ' || c == '\t') {
                    this.fwriterBuffer.append(c);
                    continue;
                }
                if (c == '\n') {
                    this.fwriterBuffer.append("\r\n");
                    continue;
                }
                char[] entity = HtmlFastEntities.HTML40.getEntity(c);
                if (entity != null) {
                    this.fwriterBuffer.append(entity);
                    continue;
                }
                this.fwriterBuffer.append(c);
            }
        } else {
            this.fwriterBuffer.append(text.ch, text.offset, text.length);
        }
    }

    protected void printStartElement(QName element, XMLAttributes attributes) {
        this.fwriterBuffer.append('<');
        this.fwriterBuffer.append(element.rawname);
        int attrCount = attributes != null ? attributes.getLength() : 0;
        Tag tag = this.tagRules.get(element.rawname);
        ArrayList<String> allAttr = new ArrayList<String>(tag.getAllowedAttributes().keySet());
        List<String> nameStartList = tag.getAllowedAttrNameStart();
        block0: for (int i = 0; i < attrCount; ++i) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (value == null || this.fPolicy.removeAttrIfEmpty() && value.trim().isEmpty()) continue;
            Attribute attr = tag.getAllowedAttributes().get(this.fPolicy.toAttrsCase(name));
            if (attr != null) {
                if (attr.handler != null && (this.fPolicy.isEnableStyleScan() || !"style".equals(name.toLowerCase()))) {
                    allAttr.remove(name);
                    attr.handler.printAttribute(this.fwriterBuffer, name, value, attr, tag, this.fPolicy);
                    continue;
                }
                boolean canAcceptAttr = false;
                if (!this.isEvilAttr(value)) {
                    String[] expr = attr.allowedRegExp;
                    if (expr != null && !value.equals("")) {
                        for (Map.Entry e : expr.entrySet()) {
                            if (OFFSITEURL.equalsIgnoreCase((String)e.getKey())) {
                                if (SafeUrlUtils.isSaveUrl(value, this.fPolicy.strictUrlCheck())) {
                                    canAcceptAttr = true;
                                } else {
                                    if (!p.matcher(value).find()) continue;
                                    canAcceptAttr = true;
                                }
                            } else {
                                if (!((Pattern)e.getValue()).matcher(value).find()) continue;
                                canAcceptAttr = true;
                            }
                            break;
                        }
                    } else {
                        canAcceptAttr = true;
                    }
                }
                if (canAcceptAttr) {
                    allAttr.remove(name);
                    this.fwriterBuffer.append(' ');
                    this.fwriterBuffer.append(name);
                    if (this.fPolicy.removeAttrIfEmpty() && value.isEmpty()) continue;
                    this.fwriterBuffer.append("=\"");
                    this.printAttributeValue(value);
                    this.fwriterBuffer.append('\"');
                    continue;
                }
                for (String noReplace : NO_REPLACE) {
                    if (!noReplace.equals(value)) continue;
                    this.fwriterBuffer.append(' ');
                    this.fwriterBuffer.append(name);
                    this.fwriterBuffer.append('=');
                    this.fwriterBuffer.append('\"');
                    this.fwriterBuffer.append(value);
                    this.fwriterBuffer.append('\"');
                }
                continue;
            }
            if (nameStartList == null) continue;
            for (String ns : nameStartList) {
                if (!name.startsWith(ns)) continue;
                this.fwriterBuffer.append(' ');
                this.fwriterBuffer.append(name);
                if (value.equals("")) continue block0;
                this.fwriterBuffer.append("=\"");
                this.printAttributeValue(value);
                this.fwriterBuffer.append('\"');
                continue block0;
            }
        }
        for (String defaultName : allAttr) {
            String defaultValue = tag.getAllowedAttributes().get((Object)defaultName).defaultValue;
            if (defaultValue == null || defaultValue.equals("")) continue;
            this.fwriterBuffer.append(' ');
            this.fwriterBuffer.append(defaultName);
            this.fwriterBuffer.append("=\"");
            this.printAttributeValue(defaultValue);
            this.fwriterBuffer.append('\"');
        }
        this.fwriterBuffer.append('>');
    }

    private boolean isEvilAttr(String value) {
        if (value == null) {
            return false;
        }
        return value.contains("</") && value.contains(">");
    }

    protected void printEmptyElement(QName element, XMLAttributes attributes) {
        this.printStartElement(element, attributes);
        this.fwriterBuffer.insert(this.fwriterBuffer.length() - 1, '/');
    }

    private void printAttributeValue(String text) {
        int length = text.length();
        for (int j = 0; j < length; ++j) {
            char c = text.charAt(j);
            if (c == '\"') {
                this.fwriterBuffer.append("&quot;");
                continue;
            }
            this.fwriterBuffer.append(c);
        }
    }

    private void printEndElement(QName element) {
        this.fwriterBuffer.append("</");
        this.fwriterBuffer.append(element.rawname);
        this.fwriterBuffer.append('>');
    }

    private TagProcessHandler getStartTagProcessHandler(TagProcessHandler handler) {
        this.stack.push(handler);
        return handler;
    }

    private TagProcessHandler getEndTagProcessHandler() {
        try {
            return this.stack.pop();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    private TagProcessHandler getProcessHandler() {
        try {
            return this.stack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    private static class InnerStack<E> {
        private static int INITIAL_CAPACITY = 32;
        private int size;
        private E[] os = new Object[INITIAL_CAPACITY];

        public void push(E o) {
            this.checkCapacity();
            this.os[this.size++] = o;
        }

        public E pop() {
            if (this.size <= 0) {
                throw new EmptyStackException();
            }
            E o = this.os[--this.size];
            this.os[this.size] = null;
            return o;
        }

        public E peek() {
            if (this.size <= 0) {
                throw new EmptyStackException();
            }
            E o = this.os[this.size - 1];
            return o;
        }

        private void checkCapacity() {
            if (this.size == this.os.length) {
                this.os = new Object[this.size * 2 + 1];
            }
        }
    }
}

