/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext.handler;

import com.alibaba.security.css.CSSParser;
import com.alibaba.security.css.DefaultDocumentHandler;
import com.alibaba.security.css.w3cinterface.InputSource;
import com.alibaba.security.xss.richtext.Policy;
import com.alibaba.security.xss.richtext.handler.TagProcessHandler;
import com.alibaba.security.xss.richtext.impl.CssDocument4TagHandler;
import com.alibaba.security.xss.richtext.model.Attribute;
import com.alibaba.security.xss.richtext.model.Tag;
import com.alibaba.securitysdk.org.apache.xerces.xni.Augmentations;
import com.alibaba.securitysdk.org.apache.xerces.xni.QName;
import com.alibaba.securitysdk.org.apache.xerces.xni.XMLAttributes;
import com.alibaba.securitysdk.org.apache.xerces.xni.XMLString;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.logging.Logger;

public class StyleTagDefaultHandelr
implements TagProcessHandler {
    private static final Logger logger = Logger.getLogger(StyleTagDefaultHandelr.class.getName());

    @Override
    public void startElement(StringBuilder writerBuffer, QName element, XMLAttributes attributes, Augmentations augs, Policy policy) {
        writerBuffer.append("<");
        writerBuffer.append(element.rawname);
        Tag tag = policy.getTagRules().get(policy.toElemsCase(element.rawname));
        Map<String, Attribute> allows = null;
        if (tag != null) {
            allows = tag.getAllowedAttributes();
        }
        if (attributes != null && allows != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                Attribute attr = allows.get(policy.toAttrsCase(name));
                if (attr == null) continue;
                String value = attributes.getValue(i);
                if (attr.handler != null) {
                    attr.handler.printAttribute(writerBuffer, name, value, attr, tag, policy);
                    continue;
                }
                writerBuffer.append(" ");
                writerBuffer.append(name);
                writerBuffer.append("=\"");
                writerBuffer.append(value);
                writerBuffer.append("\"");
            }
        }
        writerBuffer.append(">\n");
    }

    @Override
    public void endElement(StringBuilder writerBuffer, QName element, Augmentations augs) {
        writerBuffer.append("</style>");
    }

    @Override
    public void characters(StringBuilder writerBuffer, XMLString text, Augmentations augs) {
        String taintedCss = new String(text.ch, text.offset, text.length);
        if (taintedCss == null || taintedCss.trim().length() == 0) {
            return;
        }
        taintedCss = taintedCss.toLowerCase();
        CSSParser parser = new CSSParser();
        CssDocument4TagHandler handler = new CssDocument4TagHandler(writerBuffer);
        parser.setDocumentHandler((DefaultDocumentHandler)handler);
        try {
            parser.parseStyleSheet(new InputSource((Reader)new StringReader(taintedCss)));
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
    }

    @Override
    public void emptyElement(StringBuilder writerBuffer, QName element, XMLAttributes attributes, Augmentations augs, Policy policy) {
    }
}

