/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.richtext.handler;

import com.alibaba.security.util.IOUtils;
import com.alibaba.security.util.crypto.Base62;
import com.alibaba.security.xss.richtext.Policy;
import com.alibaba.security.xss.richtext.handler.AttributeProcessHandler;
import com.alibaba.security.xss.richtext.handler.PolicyAdvice;
import com.alibaba.security.xss.richtext.model.Attribute;
import com.alibaba.security.xss.richtext.model.Tag;
import com.alibaba.security.xss.richtext.tools.SafeUrlUtils;
import java.io.InputStream;
import java.util.regex.Pattern;

public class Link4TagADefaultAttributeProcessHandler
implements AttributeProcessHandler,
PolicyAdvice {
    private static final String PREFIX_KEY = "simpleanti_url_prefix";
    private static final String[] NO_REPLACE = new String[]{"#", "."};
    private static final String REGIX_PATH = "resources/excluded-regex.txt";
    private static final Pattern p;
    private String prefix = null;
    private Policy policy;

    @Override
    public void printAttribute(StringBuilder printWriter, String name, String value, Attribute attr, Tag parent, Policy policy) {
        value = value.trim();
        for (String NR : NO_REPLACE) {
            if (!NR.equals(value)) continue;
            printWriter.append(' ');
            printWriter.append(name);
            printWriter.append('=');
            printWriter.append('\"');
            printWriter.append(value);
            printWriter.append('\"');
            return;
        }
        boolean isAliGroupDomain = false;
        isAliGroupDomain = SafeUrlUtils.isSaveUrl(value, policy.strictUrlCheck()) ? true : p.matcher(value).find();
        if (isAliGroupDomain) {
            printWriter.append(' ');
            printWriter.append(name);
            printWriter.append('=');
            printWriter.append('\"');
            printWriter.append(value);
            printWriter.append('\"');
            return;
        }
        if (this.prefix == null) {
            this.prefix = policy.getDirectives().get(PREFIX_KEY);
        }
        if (this.prefix == null) {
            return;
        }
        String encodeStr = Base62.encode(value);
        printWriter.append(' ');
        printWriter.append(name);
        printWriter.append('=');
        printWriter.append('\"');
        printWriter.append(this.prefix + encodeStr);
        printWriter.append('\"');
    }

    @Override
    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    static {
        try {
            InputStream is = Link4TagADefaultAttributeProcessHandler.class.getResourceAsStream(REGIX_PATH);
            if (is == null) {
                throw new RuntimeException("No regex file can be found!");
            }
            String regex = IOUtils.convertStreamToString(is);
            p = Pattern.compile(regex);
        }
        catch (Exception e) {
            throw new RuntimeException("An error happened when reading resource file regex.txt.", e);
        }
    }
}

