/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.json;

import com.alibaba.security.parser.jsonp.Jsonp;
import com.alibaba.security.parser.jsonp.JsonpParser;
import com.alibaba.security.parser.jsonp.ParseException;
import com.alibaba.security.parser.jsonp.raw.RawJsonpParser;
import com.alibaba.security.parser.jsonp.regex.RegexJsonpParser;
import com.alibaba.security.util.IOUtils;
import com.alibaba.security.util.ResourceUtil;
import com.alibaba.security.util.StringUtils;
import com.alibaba.security.xss.html.HtmlEscape;
import com.alibaba.security.xss.html.HtmlEscapeLevel;
import com.alibaba.security.xss.html.HtmlEscapeType;
import com.alibaba.security.xss.json.JsonEscape;
import com.alibaba.security.xss.json.JsonEscapeLevel;
import com.alibaba.security.xss.json.JsonEscapeType;
import com.alibaba.security.xss.json.JsonpFunctionFilter;
import com.alibaba.security.xss.json.JsonpFunctionFilterImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class JsonpEscape {
    private static final Logger logger = Logger.getLogger(JsonpEscape.class.getName());
    private static final Pattern JSONP_PATTERN = Pattern.compile("^([a-zA-Z_$][0-9a-zA-Z_$]*)[\\s]*\\((.*)\\)[\\s]*[;]*$");
    private static final JsonpParser REGEX_JSONP_PARSER = new RegexJsonpParser();
    private static final JsonpParser RAW_JSONP_PARSER = new RawJsonpParser();
    private static volatile HtmlEscapeType defaultHtmlEscapeType = HtmlEscapeType.HTML4_NAMED_REFERENCES_DEFAULT_TO_DECIMAL;
    private static volatile HtmlEscapeLevel defaultHtmlEscapeLevel = HtmlEscapeLevel.LEVEL_1_ONLY_MARKUP_SIGNIFICANT;
    private static volatile JsonEscapeType defaultJsonEscapeType = JsonEscapeType.ESCAPE_HTML;
    private static volatile JsonEscapeLevel defaultJsonEscapeLevel = JsonEscapeLevel.LEVEL_1_BASIC_ESCAPE_SET;
    private static final JsonpFunctionFilter FUNCTION_FILTER = new JsonpFunctionFilterImpl();
    private static boolean FAST = true;

    static boolean isJsonp(String text) {
        if (text == null) {
            return false;
        }
        return JSONP_PATTERN.matcher(text).matches();
    }

    public static Jsonp parseJsonp(String text) {
        if (StringUtils.isEmpty(text)) {
            return null;
        }
        Jsonp jsonp = null;
        try {
            jsonp = REGEX_JSONP_PARSER.parse(text);
        }
        catch (ParseException e) {
            if (!FAST) {
                try {
                    jsonp = RAW_JSONP_PARSER.parse(text);
                }
                catch (Exception e2) {
                    logger.warning(e2.getMessage());
                    return null;
                }
                catch (Throwable err) {
                    logger.warning(err.getMessage());
                    return null;
                }
            }
            logger.warning(e.getMessage());
        }
        return jsonp;
    }

    public static String escapeJsonp(String text) {
        return JsonpEscape.escapeJsonp(text, null, null, null, null);
    }

    public static String escapeJsonp(String text, HtmlEscapeType htmlEscapeType, HtmlEscapeLevel htmlEscapeLevel, JsonEscapeType jsonEscapeType, JsonEscapeLevel jsonEscapeLevel) {
        if (text == null) {
            return null;
        }
        htmlEscapeType = htmlEscapeType == null ? defaultHtmlEscapeType : htmlEscapeType;
        htmlEscapeLevel = htmlEscapeLevel == null ? defaultHtmlEscapeLevel : htmlEscapeLevel;
        jsonEscapeType = jsonEscapeType == null ? defaultJsonEscapeType : jsonEscapeType;
        jsonEscapeLevel = jsonEscapeLevel == null ? defaultJsonEscapeLevel : jsonEscapeLevel;
        Jsonp jsonp = JsonpEscape.parseJsonp(text);
        if (jsonp == null) {
            return null;
        }
        String escapedCallback = HtmlEscape.escapeHtml(jsonp.getCallback(), htmlEscapeType, htmlEscapeLevel);
        String escapedJson = JsonEscape.escapeJson(jsonp.getJson(), jsonEscapeType, jsonEscapeLevel);
        jsonp.setCallback(escapedCallback);
        jsonp.setJson(escapedJson);
        return jsonp.toString();
    }

    public static String doFilter(String text) {
        return JsonpEscape.doFilter(text, FUNCTION_FILTER, null, null);
    }

    public static String doFilter(String text, JsonpFunctionFilter functionFilter, JsonEscapeType jsonEscapeType, JsonEscapeLevel jsonEscapeLevel) {
        if (text == null) {
            return null;
        }
        jsonEscapeType = jsonEscapeType == null ? defaultJsonEscapeType : jsonEscapeType;
        jsonEscapeLevel = jsonEscapeLevel == null ? defaultJsonEscapeLevel : jsonEscapeLevel;
        Jsonp jsonp = JsonpEscape.parseJsonp(text);
        if (jsonp == null) {
            return null;
        }
        String escapedCallback = functionFilter.doFilter(jsonp.getCallback());
        String escapedJson = JsonEscape.escapeJson(jsonp.getJson(), jsonEscapeType, jsonEscapeLevel);
        jsonp.setCallback(escapedCallback);
        jsonp.setJson(escapedJson);
        return jsonp.toString();
    }

    public static synchronized void setDefaultJsonEscapeType(JsonEscapeType defaultEscapeType) {
        defaultJsonEscapeType = defaultEscapeType;
    }

    public static synchronized void setDefaultJsonEscapeLevel(JsonEscapeLevel defaultEscapeLevel) {
        defaultJsonEscapeLevel = defaultEscapeLevel;
    }

    public static synchronized void setDefaultHtmlEscapeType(HtmlEscapeType defaultHtmlEscapeType) {
        JsonpEscape.defaultHtmlEscapeType = defaultHtmlEscapeType;
    }

    public static synchronized void setDefaultHtmlEscapeLevel(HtmlEscapeLevel defaultHtmlEscapeLevel) {
        JsonpEscape.defaultHtmlEscapeLevel = defaultHtmlEscapeLevel;
    }

    static {
        InputStream is = ResourceUtil.getDefaultConfigInputStream();
        try {
            Properties props = new Properties();
            if (is != null) {
                props.load(is);
                if ("false".equalsIgnoreCase(props.getProperty("security.xss.jsonp.parsing.fast", "true").trim())) {
                    FAST = false;
                    logger.log(Level.WARNING, "Now this process performs formally as a real parsing, or be more predict, parsing after tokenizing and lexing.");
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Fail to load the configuration files of jsonp parsing. Fast parsing mode is now configured by default.");
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }
}

