/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.security.xss.checker;

import com.alibaba.security.util.StringEscapeUtils;
import com.alibaba.security.xss.XssChecker;
import com.alibaba.security.xss.checker.XSSCheckRules;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class XSSCheckerImpl
implements XssChecker {
    private final Set<String> whitelists = new ConcurrentSkipListSet<String>();

    public boolean checkXSSSafe(String input) {
        if (input == null || input.trim().isEmpty()) {
            return true;
        }
        if (this.checkWhiteList(input = input.trim())) {
            return true;
        }
        String purifyInput = XSSCheckerImpl.purifyForRegex(input);
        boolean result = this.checkByRegex(purifyInput);
        if (result) {
            purifyInput = XSSCheckerImpl.purifyForMatch(purifyInput);
            result = this.checkHtmlAndCheck(purifyInput);
        }
        return result;
    }

    private boolean checkWhiteList(String input) {
        for (String wl : this.whitelists) {
            if (!input.toLowerCase().contains(wl.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private boolean checkByRegex(String input) {
        List<Pattern> patterns = XSSCheckRules.patterns();
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(input).find()) continue;
            return false;
        }
        return true;
    }

    private boolean checkHtmlAndCheck(String html) {
        Document document = Jsoup.parse((String)html);
        Elements elements = document.getAllElements();
        for (Element element : elements) {
            Attributes attributes;
            String tagName = element.tagName();
            if (this.checkTag(tagName, attributes = element.attributes())) continue;
            return false;
        }
        return true;
    }

    private boolean checkTag(String tagName, Attributes attributes) {
        List<String> blackTags = XSSCheckRules.blackTags();
        for (String blackTag : blackTags) {
            if (!blackTag.equalsIgnoreCase(this.purifyTagName(tagName))) continue;
            return false;
        }
        boolean checkAttr = this.checkAttr(attributes);
        return checkAttr;
    }

    private boolean checkAttr(Attributes attributes) {
        List<String> blackAttributes = XSSCheckRules.blackAttributes();
        for (Attribute attribute : attributes) {
            for (String blackAttribute : blackAttributes) {
                if (!blackAttribute.equalsIgnoreCase(this.purifyAttrKey(attribute.getKey()))) continue;
                return false;
            }
        }
        return true;
    }

    private String purifyTagName(String tagName) {
        if (tagName == null) {
            return null;
        }
        return tagName.trim();
    }

    private String purifyAttrKey(String attrKey) {
        if (attrKey == null) {
            return null;
        }
        return attrKey.trim();
    }

    private static String purifyForRegex(String input) {
        return XSSCheckerImpl.purify0(input);
    }

    private static String purifyForMatch(String purifyStr) {
        return purifyStr.replaceAll("/", " ");
    }

    private static String purify0(String input) {
        String purifyStr = input;
        try {
            purifyStr = URLDecoder.decode(purifyStr, StandardCharsets.UTF_8.name());
        }
        catch (Exception exception) {
            // empty catch block
        }
        purifyStr = StringEscapeUtils.unescapeHtml(purifyStr);
        purifyStr = purifyStr.toLowerCase();
        purifyStr = XSSCheckerImpl.removeNotes(purifyStr);
        purifyStr = purifyStr.replaceAll("\t", "");
        purifyStr = purifyStr.replaceAll("\n", "");
        return purifyStr;
    }

    private static String removeNotes(String input) {
        StringBuilder buf = new StringBuilder();
        char[] chars = input.toCharArray();
        boolean enterNotes = false;
        int enterNoteIndex = -1;
        int lastChar = 0;
        int lastCharIndex = enterNoteIndex;
        int noteOffset = 0;
        int i = 0;
        while (i < chars.length) {
            int c = chars[i];
            if (c == 42 && lastChar == 47) {
                enterNotes = true;
                enterNoteIndex = i;
            }
            buf.append((char)c);
            if (enterNotes && lastCharIndex != enterNoteIndex && c == 47 && lastChar == 42) {
                enterNotes = false;
                int start = enterNoteIndex - 1 - noteOffset;
                int end = i + 1 - noteOffset;
                buf.delete(start, end);
                noteOffset += end - start;
            }
            lastChar = c;
            lastCharIndex = i++;
        }
        return buf.toString();
    }

    public void addWhitelist(String wl) {
        if (wl != null && !wl.isEmpty()) {
            this.whitelists.add(wl.trim());
        }
    }

    public void delWhitelist(String wl) {
        if (wl != null && !wl.trim().isEmpty()) {
            this.whitelists.remove(wl.trim());
        }
    }

    public List<String> listWhitelist() {
        return new ArrayList<String>(this.whitelists);
    }
}

